/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression.element;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.math.NumberUtils;

public class QueueElement
extends LogicElement {
    private List<Rule> ruleList = new ArrayList<Rule>(5);

    public QueueElement(String expression, RuleCache ruleCache) {
        this.expression = expression;
        String[] exs = expression.split("#");
        Rule rule = null;
        String[] stringArray = exs;
        int n = exs.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleId = stringArray[n2];
            rule = ruleCache.getRule(ruleId);
            if (rule == null) {
                throw new RuleNotFoundException("Can't find the rule object by ruleId: " + ruleId);
            }
            this.ruleList.add(rule);
            ++n2;
        }
    }

    @Override
    public boolean exec(RuleMatchResultCache resultCache, CauseMatchResult matchResult) {
        ArrayList<List<RecordInfo>> list = new ArrayList<List<RecordInfo>>();
        for (Rule rule : this.ruleList) {
            Vector<RecordInfo> v = resultCache.getRecordResultList(rule);
            if (v == null) {
                return false;
            }
            Collections.sort(v);
            list.add(v);
            matchResult.addRecordInfoList(rule.getId(), v);
        }
        ResultCombination rc = new ResultCombination(this.expression);
        ArrayList<RecordInfo> combination = new ArrayList<RecordInfo>(list.size());
        this.doDateSort(list, combination);
        this.doLineNumberSort(list, rc, combination);
        if (combination.size() == list.size()) {
            rc.add(combination);
        }
        matchResult.addResultCombination(rc);
        return rc.find();
    }

    private void doLineNumberSort(List<List<RecordInfo>> list, ResultCombination rc, List<RecordInfo> combination) {
        if (combination.isEmpty()) {
            HashMap<File, List<RecordInfo>> map = new HashMap<File, List<RecordInfo>>();
            int i = 0;
            while (i < list.size()) {
                List<RecordInfo> l2 = list.get(i);
                HashMap<File, List<RecordInfo>> subMap = new HashMap<File, List<RecordInfo>>();
                for (RecordInfo recordInfo : l2) {
                    ArrayList<RecordInfo> riList = (ArrayList<RecordInfo>)subMap.get(new File(recordInfo.getFilePath()));
                    if (riList == null) {
                        riList = new ArrayList<RecordInfo>();
                        subMap.put(new File(recordInfo.getFilePath()), riList);
                    }
                    riList.add(recordInfo);
                }
                this.addRecordInfo(map, subMap);
                ++i;
            }
            for (Map.Entry e1 : map.entrySet()) {
                if (((List)e1.getValue()).size() != list.size()) continue;
                rc.add((List)e1.getValue());
                break;
            }
        }
    }

    private void addRecordInfo(Map<File, List<RecordInfo>> map, Map<File, List<RecordInfo>> subMap) {
        block0: for (Map.Entry<File, List<RecordInfo>> e : subMap.entrySet()) {
            List<RecordInfo> riList = map.get(e.getKey());
            if (riList == null) {
                riList = new ArrayList<RecordInfo>();
                map.put(e.getKey(), riList);
            }
            if (riList.isEmpty()) {
                riList.add(e.getValue().get(0));
                continue;
            }
            for (RecordInfo recordInfo : e.getValue()) {
                if (recordInfo.getLineNumber() <= riList.get(riList.size() - 1).getLineNumber()) continue;
                riList.add(recordInfo);
                continue block0;
            }
        }
    }

    private void doDateSort(List<List<RecordInfo>> list, List<RecordInfo> combination) {
        RecordInfo recordInfo = null;
        int i = list.size() - 1;
        while (i >= 0) {
            List<RecordInfo> l2 = list.get(i);
            if (recordInfo == null) {
                int i2 = 0;
                while (i2 < l2.size()) {
                    RecordInfo recordInfo2 = l2.get(i2);
                    if (recordInfo2.getDateInfo() != null) {
                        recordInfo = recordInfo2;
                    }
                    ++i2;
                }
            } else {
                boolean flag = false;
                int i2 = l2.size() - 1;
                while (i2 >= 0) {
                    int compareResult;
                    RecordInfo recordInfo1 = l2.get(i2);
                    if (recordInfo1.getDateInfo() != null && (compareResult = this.compareDateAndJiffies(recordInfo, recordInfo1)) > 0) {
                        recordInfo = recordInfo1;
                        flag = true;
                        break;
                    }
                    --i2;
                }
                if (!flag) break;
            }
            if (recordInfo == null) {
                return;
            }
            combination.add(recordInfo);
            --i;
        }
    }

    private int compareDateAndJiffies(RecordInfo o1, RecordInfo o2) {
        int compareResult = o1.compareTo(o2);
        if (compareResult > 0) {
            return 1;
        }
        if (compareResult == 0) {
            String jiffies1 = this.getFieldFromLine(o1.getContent().toString(), 1);
            String jiffies2 = this.getFieldFromLine(o2.getContent().toString(), 1);
            if (!NumberUtils.isNumber((String)jiffies1) && !NumberUtils.isNumber((String)jiffies2)) {
                if (new File(o1.getFilePath()).equals(new File(o2.getFilePath())) && o1.getLineNumber() > o2.getLineNumber()) {
                    return 1;
                }
                return -1;
            }
            int ret = jiffies1.compareTo(jiffies2);
            if (ret >= 1 && o1.getLineNumber() > o2.getLineNumber()) {
                return 1;
            }
            if (ret == 0) {
                if (new File(o1.getFilePath()).equals(new File(o2.getFilePath())) && o1.getLineNumber() > o2.getLineNumber()) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    private String getFieldFromLine(String line, int index) {
        StringBuilder field = new StringBuilder();
        try {
            line = line.replaceAll("\\[", "");
            String[] fields = line.split("\\]");
            if (fields.length <= index || index < 0) {
                return field.toString();
            }
            String tmp = fields[index];
            if (tmp.length() == 0) {
                return field.toString();
            }
            field.append(tmp.trim());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Parser log error.", (Throwable)e);
        }
        return field.toString();
    }

    @Override
    public List<Rule> getRuleList() {
        return this.ruleList;
    }
}

