/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression.element;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueueTimeIntervalElement
extends LogicElement {
    private static final Pattern SPLITOR_PATTERN = Pattern.compile("#\\d+\\-\\d+#");
    private List<Rule> ruleList = new ArrayList<Rule>(5);
    private List<TimeRange> trList = new ArrayList<TimeRange>();

    public QueueTimeIntervalElement(String expression, RuleCache ruleCache) {
        this.expression = expression;
        String[] ruleIds = SPLITOR_PATTERN.split(expression);
        Rule rule = null;
        String[] stringArray = ruleIds;
        int n = ruleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleId = stringArray[n2];
            rule = ruleCache.getRule(ruleId);
            if (rule == null) {
                throw new RuleNotFoundException("Can't find the rule object by ruleId: " + ruleId);
            }
            this.ruleList.add(rule);
            ++n2;
        }
        Matcher m = MatcherUtils.match(expression, SPLITOR_PATTERN);
        while (m != null && m.find()) {
            this.trList.add(new TimeRange(m.group()));
        }
    }

    @Override
    public boolean exec(RuleMatchResultCache resultCache, CauseMatchResult matchResult) {
        ArrayList<Vector<RecordInfo>> list = new ArrayList<Vector<RecordInfo>>();
        for (Rule rule : this.ruleList) {
            Vector<RecordInfo> v = resultCache.getRecordResultList(rule);
            if (v == null) {
                return false;
            }
            Collections.sort(v);
            list.add(v);
            matchResult.addRecordInfoList(rule.getId(), v);
        }
        ResultCombination rc = new ResultCombination(this.expression);
        ArrayList<RecordInfo> combination = new ArrayList<RecordInfo>(list.size());
        RecordInfo recordInfo = null;
        int i = list.size() - 1;
        while (i >= 0) {
            int i2;
            List l2 = (List)list.get(i);
            if (recordInfo == null) {
                i2 = l2.size() - 1;
                while (i2 >= 0) {
                    RecordInfo recordInfo2 = (RecordInfo)l2.get(i2);
                    if (recordInfo2.getDateInfo() != null) {
                        recordInfo = recordInfo2;
                    }
                    --i2;
                }
            } else {
                i2 = l2.size() - 1;
                while (i2 >= 0) {
                    RecordInfo recordInfo1 = (RecordInfo)l2.get(i2);
                    if (recordInfo1.getDateInfo() != null && this.trList.get(i).isInRange(recordInfo.getDateInfo().getTime() - recordInfo1.getDateInfo().getTime())) {
                        recordInfo = recordInfo1;
                        break;
                    }
                    --i2;
                }
            }
            if (recordInfo == null) {
                return false;
            }
            combination.add(recordInfo);
            --i;
        }
        if (combination.size() == list.size()) {
            rc.add(combination);
        }
        matchResult.addResultCombination(rc);
        return rc.find();
    }

    @Override
    public List<Rule> getRuleList() {
        return this.ruleList;
    }

    private static final class TimeRange {
        private long start;
        private long end;

        private TimeRange(String timeRangeStrInfo) {
            String timeRangeStr = timeRangeStrInfo.replaceAll("^#|#$", "");
            String[] strs = timeRangeStr.split("\\-");
            this.start = Long.parseLong(strs[0]);
            if (strs.length > 1) {
                this.end = Long.parseLong(strs[1]);
            }
        }

        private boolean isInRange(long dest) {
            return dest >= this.start && dest <= this.end;
        }
    }
}

