/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression.element;

import com.huawei.ism.tool.loganalyzer.faulttree.command.model.FaultObject;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.LogicCalculateException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TimeIntervalElement
extends LogicElement {
    private List<CommonRule> commonRuleList = new ArrayList<CommonRule>(5);
    private Rule referenceRule;
    private long start;
    private long end;

    public TimeIntervalElement(String expression, RuleCache ruleCache) {
        this.expression = expression;
        String[] expressionStrs = expression.split("\\|");
        this.referenceRule = ruleCache.getRule(expressionStrs[0]);
        if (this.referenceRule == null) {
            throw new RuleNotFoundException("Can't find the rule object by ruleId: " + expressionStrs[0]);
        }
        String[] ruleIds = expressionStrs[2].split(",");
        Rule rule = null;
        String[] stringArray = ruleIds;
        int n = ruleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleId = stringArray[n2];
            rule = ruleCache.getRule(ruleId.replace("!", ""));
            if (rule == null) {
                throw new RuleNotFoundException("Can't find the rule object by ruleId: " + ruleId);
            }
            CommonRule cr = new CommonRule();
            cr.setReverse(ruleId.startsWith("!"));
            cr.setRule(rule);
            this.commonRuleList.add(cr);
            ++n2;
        }
        this.initTimeRange(expression);
    }

    private void initTimeRange(String expression) {
        try {
            String[] timeRangeStr = expression.split("\\|");
            String[] strs = timeRangeStr[1].split("\\-");
            this.start = Long.parseLong(strs[0]);
            if (strs.length > 1) {
                this.end = Long.parseLong(strs[1]);
            }
        }
        catch (Exception e) {
            throw new LogicCalculateException("Executing the Logic-operation occor an error:" + expression, e);
        }
    }

    @Override
    public boolean exec(RuleMatchResultCache resultCache, CauseMatchResult matchResult) {
        Vector<RecordInfo> referenceList = resultCache.getRecordResultList(this.referenceRule);
        if (referenceList == null) {
            return false;
        }
        matchResult.addRecordInfoList(this.referenceRule.getId(), referenceList);
        Collections.sort(referenceList);
        ResultCombination rc = new ResultCombination(this.expression);
        int i = referenceList.size() - 1;
        while (i >= 0) {
            RecordInfo targetRi = (RecordInfo)referenceList.get(i);
            if (targetRi.getDateInfo() != null) {
                if (!this.exec(resultCache, matchResult, targetRi)) {
                    return false;
                }
                ArrayList<RecordInfo> combination = new ArrayList<RecordInfo>(1);
                combination.add(targetRi);
                rc.add(combination);
            }
            --i;
        }
        matchResult.addResultCombination(rc);
        return rc.find();
    }

    private boolean exec(RuleMatchResultCache resultCache, CauseMatchResult matchResult, RecordInfo targetRi) {
        FaultObject targetFo = targetRi.getFaultObjectList().isEmpty() ? null : targetRi.getFaultObjectList().get(0);
        for (CommonRule commonRule : this.commonRuleList) {
            List<RecordInfo> recordInfoList = this.getRecordInfoList(commonRule.getRule(), resultCache, matchResult);
            if (recordInfoList == null && !commonRule.isReverse()) {
                return false;
            }
            if (recordInfoList == null || this.exec(targetRi, targetFo, commonRule, recordInfoList)) continue;
            return false;
        }
        return true;
    }

    private boolean exec(RecordInfo targetRi, FaultObject targetFo, CommonRule commonRule, List<RecordInfo> recordInfoList) {
        int j = recordInfoList.size() - 1;
        while (j >= 0) {
            RecordInfo commonRi = recordInfoList.get(j);
            if (commonRi.getDateInfo() != null) {
                FaultObject commonFo;
                FaultObject faultObject = commonFo = commonRi.getFaultObjectList().isEmpty() ? null : commonRi.getFaultObjectList().get(0);
                if (targetFo != null && commonFo != null && targetFo.equals(commonFo) || commonFo == null && targetFo == null) {
                    long dest = Math.abs(commonRi.getDateInfo().getTime() - targetRi.getDateInfo().getTime());
                    if (!(commonRule.isReverse() && !this.isInRange(dest) || !commonRule.isReverse() && this.isInRange(dest))) {
                        return false;
                    }
                }
            }
            --j;
        }
        return true;
    }

    private List<RecordInfo> getRecordInfoList(Rule rule, RuleMatchResultCache resultCache, CauseMatchResult matchResult) {
        Vector<RecordInfo> v = resultCache.getRecordResultList(rule);
        if (v == null) {
            return null;
        }
        Collections.sort(v);
        matchResult.addRecordInfoList(rule.getId(), v);
        return v;
    }

    @Override
    public List<Rule> getRuleList() {
        ArrayList<Rule> ruleList = new ArrayList<Rule>(5);
        for (CommonRule commonRule : this.commonRuleList) {
            ruleList.add(commonRule.getRule());
        }
        ruleList.add(this.referenceRule);
        return ruleList;
    }

    private boolean isInRange(long dest) {
        return dest >= this.start && dest <= this.end;
    }

    private static final class CommonRule {
        private boolean reverse;
        private Rule rule;

        private CommonRule() {
        }

        private boolean isReverse() {
            return this.reverse;
        }

        private void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        private Rule getRule() {
            return this.rule;
        }

        private void setRule(Rule rule) {
            this.rule = rule;
        }
    }
}

