/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression.templet;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.OperationElementCreateException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleParseException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.element.CommonElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.element.QueueElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.element.QueueTimeIntervalElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.element.TimeIntervalElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.OperatorElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class LogicElement
extends OperatorElement {
    private static final Map<Pattern, Constructor<? extends LogicElement>> ELEMENTMAP = new HashMap<Pattern, Constructor<? extends LogicElement>>();
    public String expression;

    static {
        try {
            ELEMENTMAP.put(Pattern.compile("^!?\\w+$"), CommonElement.class.getConstructor(String.class, RuleCache.class));
            ELEMENTMAP.put(Pattern.compile("^\\w+(#\\w+)+$"), QueueElement.class.getConstructor(String.class, RuleCache.class));
            ELEMENTMAP.put(Pattern.compile("^\\w*(#\\d+-\\d+#\\w+)+$"), QueueTimeIntervalElement.class.getConstructor(String.class, RuleCache.class));
            ELEMENTMAP.put(Pattern.compile("^\\w+\\|\\d+-\\d+\\|!?\\w+(,!?\\w+)*$"), TimeIntervalElement.class.getConstructor(String.class, RuleCache.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuleNotFoundException("Init LogicElement failed: ", e);
        }
        catch (SecurityException e1) {
            throw new OperationElementCreateException("Init LogicElement failed: ", e1);
        }
    }

    public static final LogicElement getElement(String expression, RuleCache ruleCache) {
        try {
            for (Map.Entry<Pattern, Constructor<? extends LogicElement>> e : ELEMENTMAP.entrySet()) {
                if (!e.getKey().matcher(expression).matches()) continue;
                return e.getValue().newInstance(expression, ruleCache);
            }
            throw new OperationElementCreateException("Creating OperationElement failed, Can't find the classType:" + expression);
        }
        catch (OperationElementCreateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuleParseException("Creating OperationElement failed:" + expression, e);
        }
    }

    public abstract boolean exec(RuleMatchResultCache var1, CauseMatchResult var2);

    public abstract List<Rule> getRuleList();

    public String toString() {
        return "LogicElement [expression=" + this.expression + "]";
    }
}

