/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.model;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.CauseGroupCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.FaultTypeCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.VersionSupportsCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Model;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.cache.FileCategorizerCache;
import com.huawei.ism.tool.loganalyzer.faulttree.datematch.DateMatcherCache;
import com.huawei.ism.tool.loganalyzer.faulttree.resources.cache.ResourceCache;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public enum DeviceType {
    UNIFINED("unifined"),
    OCEAN_STOR("oceanstor");

    private static final String CONF_PATH;
    private VersionSupportsCache versionSupportsCache = new VersionSupportsCache();
    private FileCategorizerCache fileCategorizerCache = new FileCategorizerCache();
    private DateMatcherCache dateMatcherCache = new DateMatcherCache();
    private RuleCache ruleCache = new RuleCache();
    private FaultTypeCache faultTypeCache = new FaultTypeCache();
    private CauseGroupCache causeGroupCache = new CauseGroupCache();
    private ResourceCache resourceCache = new ResourceCache();
    private String confPath;
    private String name;
    private static final Logger LOGGER;

    static {
        CONF_PATH = String.valueOf(ApplicationContext.getInstance().getWorkPath()) + File.separator + "packages" + File.separator + "AnalyzeLogTool" + File.separator + "conf";
        LOGGER = Logger.getLogger(DeviceType.class);
    }

    private DeviceType(String name) {
        this.name = name;
    }

    public static final void init() {
        DeviceType.UNIFINED.confPath = String.valueOf(CONF_PATH) + File.separator + DeviceType.UNIFINED.name;
        DeviceType.OCEAN_STOR.confPath = String.valueOf(CONF_PATH) + File.separator + DeviceType.OCEAN_STOR.name;
        LOGGER.info((Object)("init faulttree path" + DeviceType.UNIFINED.confPath));
    }

    public static void silenceInit(String rulePath) {
        DeviceType.UNIFINED.confPath = String.valueOf(rulePath) + File.separator + DeviceType.UNIFINED.name;
        DeviceType.OCEAN_STOR.confPath = String.valueOf(rulePath) + File.separator + DeviceType.OCEAN_STOR.name;
        LOGGER.info((Object)("silence init faulttree path" + DeviceType.UNIFINED.confPath));
    }

    public static final Model getModel(String modelName, String versionName) {
        Model m = null;
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType storageDeviceType = deviceTypeArray[n2];
            m = storageDeviceType.versionSupportsCache.getModel(modelName, versionName);
            if (m != null) {
                return m;
            }
            ++n2;
        }
        return m;
    }

    public static final Model getModel(String modelName) {
        Model m = null;
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType storageDeviceType = deviceTypeArray[n2];
            m = storageDeviceType.versionSupportsCache.getModel(modelName);
            if (m != null) {
                return m;
            }
            ++n2;
        }
        return m;
    }

    public static final DeviceType type(String modelName) {
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType storageDeviceType = deviceTypeArray[n2];
            if (storageDeviceType.versionSupportsCache.getModel(modelName) != null) {
                return storageDeviceType;
            }
            ++n2;
        }
        return UNIFINED;
    }

    public static final List<Model> getModelList() {
        ArrayList<Model> modelList = new ArrayList<Model>();
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType storageDeviceType = deviceTypeArray[n2];
            modelList.addAll(storageDeviceType.versionSupportsCache.getModelList());
            ++n2;
        }
        return modelList;
    }

    public VersionSupportsCache versionSupportsCache() {
        return this.versionSupportsCache;
    }

    public FileCategorizerCache fileCategorizerCache() {
        return this.fileCategorizerCache;
    }

    public RuleCache ruleCache() {
        return this.ruleCache;
    }

    public FaultTypeCache faultTypeCache() {
        return this.faultTypeCache;
    }

    public CauseGroupCache causeGroupCache() {
        return this.causeGroupCache;
    }

    public DateMatcherCache dateMatcherCache() {
        return this.dateMatcherCache;
    }

    public ResourceCache resourceCache() {
        return this.resourceCache;
    }

    public String getName() {
        return this.name;
    }

    public String getConfPath() {
        return this.confPath;
    }
}

