/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.resources.parser;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ResourceParser {
    private static final Logger LOGGER = Logger.getLogger(ResourceParser.class);

    public static final Properties parse(Locale local, DeviceType type) {
        File resourcesDir = new File(String.valueOf(type.getConfPath()) + File.separator + "resources");
        String suffixProperties = String.valueOf(local.getLanguage()) + ".properties";
        Properties p = new Properties();
        ResourceParser.parse(p, suffixProperties, resourcesDir);
        return p;
    }

    private static final void parse(Properties p, String suffixProperties, File resourcesDir) {
        File[] files = resourcesDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ResourceParser.parse(p, suffixProperties, file);
                } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(suffixProperties)) {
                    p.putAll((Map<?, ?>)ResourceParser.parse(file));
                }
                ++n2;
            }
        }
    }

    private static final Properties parse(File propertiesFile) {
        Properties p;
        block5: {
            p = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(propertiesFile);
                    p.load(in);
                    LOGGER.info((Object)("Silence Analyse Rule name:" + p.getProperty("08_01_01_01_01.issue.name")));
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(ResourceParser.class).error("Read properties failed.", (Throwable)e);
                    IOUtils.close((Closeable)in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close((Closeable)in);
        }
        return p;
    }
}

