/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;

public class RuleMatchResultCache {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RuleMatchResultCache.class);
    private Map<Rule, Vector<RecordInfo>> recordResultListMap = new HashMap<Rule, Vector<RecordInfo>>();

    public synchronized void add(RecordInfo recordResult, DeviceType deviceType) {
        Vector<RecordInfo> recordResultList = this.recordResultListMap.get(deviceType.ruleCache().getRule(recordResult.getRuleId()));
        if (recordResultList == null) {
            recordResultList = new Vector();
            this.recordResultListMap.put(deviceType.ruleCache().getRule(recordResult.getRuleId()), recordResultList);
        }
        recordResultList.add(recordResult);
    }

    public Vector<RecordInfo> getRecordResultList(Rule rule) {
        return this.recordResultListMap.get(rule);
    }

    public void searchFaultObject(DeviceType deviceType) {
        for (Map.Entry<Rule, Vector<RecordInfo>> e : this.recordResultListMap.entrySet()) {
            for (RecordInfo recordInfo : e.getValue()) {
                recordInfo.searchFaultObject(deviceType);
            }
        }
    }

    public void findDateInfo(DeviceType deviceType) {
        for (Map.Entry<Rule, Vector<RecordInfo>> e : this.recordResultListMap.entrySet()) {
            for (RecordInfo recordInfo : e.getValue()) {
                recordInfo.updateDateInfo(deviceType);
            }
        }
    }

    public void diagnose() {
        for (Map.Entry<Rule, Vector<RecordInfo>> e : new HashMap<Rule, Vector<RecordInfo>>(this.recordResultListMap).entrySet()) {
            this.diagnose(e.getKey(), e.getValue());
        }
    }

    private void diagnose(Rule rule, Vector<RecordInfo> v) {
        LOGGER.info("Silence Analyse Diagnose Rule ID:" + rule.getId());
        try {
            rule.getDiagnoseCommands().diagnose(v);
        }
        catch (DiagnoseCommandExecuteException e) {
            this.recordResultListMap.remove(rule);
        }
        catch (Exception e) {
            LOGGER.info("The match result of the rule[" + rule + "] diagnose occor an error.", (Throwable)e);
        }
    }
}

