/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model;

import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CauseMatchResult {
    private String causeId;
    private String logicExpression;
    private boolean ifMatch;
    private Map<String, ResultCombination> combinationMap = new HashMap<String, ResultCombination>();
    private Map<String, List<RecordInfo>> recordInfoMap = new HashMap<String, List<RecordInfo>>();

    public CauseMatchResult() {
    }

    public CauseMatchResult(String logicExpression) {
        this.logicExpression = logicExpression;
    }

    public boolean isMatch() {
        return this.ifMatch;
    }

    public void setMatch(boolean isMatch) {
        this.ifMatch = isMatch;
    }

    public void addResultCombination(ResultCombination rc) {
        this.combinationMap.put(rc.getName(), rc);
    }

    public DateInfo getDateInfo() {
        ArrayList<DateInfo> dateInfoList = new ArrayList<DateInfo>(4);
        DateInfo di = null;
        for (ResultCombination combination : this.combinationMap.values()) {
            di = combination.getDateInfo();
            if (di == null) continue;
            dateInfoList.add(di);
        }
        if (!dateInfoList.isEmpty()) {
            Collections.sort(dateInfoList);
            return (DateInfo)dateInfoList.get(dateInfoList.size() - 1);
        }
        return null;
    }

    public void addRecordInfoList(String ruleId, List<RecordInfo> riList) {
        this.recordInfoMap.put(ruleId, riList);
    }

    public String getLogicExpression() {
        return this.logicExpression;
    }

    public Map<String, ResultCombination> getCombinationMap() {
        return this.combinationMap;
    }

    public Map<String, List<RecordInfo>> getRecordInfoMap() {
        return this.recordInfoMap;
    }

    public String getCauseId() {
        return this.causeId;
    }

    public void setCauseId(String causeId) {
        this.causeId = causeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.causeId == null ? 0 : this.causeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CauseMatchResult other = (CauseMatchResult)obj;
        return !(this.causeId == null ? other.causeId != null : !this.causeId.equals(other.causeId));
    }
}

