/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.FaultObject;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.ObjectCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecordInfo
implements Comparable<RecordInfo> {
    private String ruleId;
    private CharSequence content;
    private int lineNumber;
    private DateInfo dateInfo;
    private List<FaultObject> faultObjectList = new ArrayList<FaultObject>(1);
    private String filePath;

    public void searchFaultObject(DeviceType deviceType) {
        Rule rule = deviceType.ruleCache().getRule(this.ruleId);
        if (rule != null) {
            List<ObjectCommand> objectCommandList = rule.getObjectCommandList();
            FaultObject faultObject = null;
            for (ObjectCommand objectCommand : objectCommandList) {
                faultObject = objectCommand.find(this.content);
                if (faultObject == null) continue;
                this.faultObjectList.add(faultObject);
            }
        }
    }

    public void updateDateInfo(DeviceType deviceType) {
        Rule rule = deviceType.ruleCache().getRule(this.ruleId);
        if (rule != null) {
            List<MatchCommand> matchCommandList = rule.getMatchCommandList();
            ArrayList<DateInfo> dateInfoList = new ArrayList<DateInfo>();
            DateInfo dataInfo = null;
            for (MatchCommand matchCommand : matchCommandList) {
                dataInfo = matchCommand.find(this.content);
                if (dataInfo == null) continue;
                dateInfoList.add(dataInfo);
            }
            if (!dateInfoList.isEmpty()) {
                Collections.sort(dateInfoList);
                this.dateInfo = (DateInfo)dateInfoList.get(dateInfoList.size() - 1);
            }
        }
    }

    public void setDateInfo(DateInfo dateInfo) {
        this.dateInfo = dateInfo;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public void setContent(CharSequence content) {
        this.content = content;
    }

    public DateInfo getDateInfo() {
        return this.dateInfo;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public List<FaultObject> getFaultObjectList() {
        return this.faultObjectList;
    }

    public String toString() {
        return "RecordInfo [ruleId=" + this.ruleId + ", content=" + this.content + ", lineNumber=" + this.lineNumber + ", dateInfo=" + this.dateInfo + ", faultObjectList=" + this.faultObjectList + ", file=" + this.filePath + "]";
    }

    @Override
    public int compareTo(RecordInfo o) {
        long time2;
        if (this.dateInfo == null && o.dateInfo == null) {
            if (!StringUtils.isNULLStr((String)this.getFilePath()) && !StringUtils.isNULLStr((String)o.getFilePath())) {
                if (this.getFilePath().equals(o.getFilePath())) {
                    return this.lineNumber - o.lineNumber;
                }
                return this.getFilePath().compareTo(o.getFilePath());
            }
            if (StringUtils.isNULLStr((String)this.getFilePath()) && StringUtils.isNULLStr((String)o.getFilePath())) {
                return this.lineNumber - o.lineNumber;
            }
        }
        long time1 = this.dateInfo == null ? 0L : this.dateInfo.getTime();
        long l = time2 = o.dateInfo == null ? 0L : o.dateInfo.getTime();
        return time1 > time2 ? 1 : (time1 == time2 ? 0 : -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ruleId == null ? 0 : this.ruleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordInfo other = (RecordInfo)obj;
        return !(this.ruleId == null ? other.ruleId != null : !this.ruleId.equals(other.ruleId));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }
}

