/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model;

import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResultCombination {
    private String name;
    private List<Combination> combinationList = new ArrayList<Combination>();

    public ResultCombination() {
    }

    public ResultCombination(String name) {
        this.name = name;
    }

    public void add(List<RecordInfo> combination) {
        this.combinationList.add(new Combination(combination));
    }

    public List<Combination> getCombinationList() {
        return this.combinationList;
    }

    public boolean find() {
        return !this.combinationList.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public DateInfo getDateInfo() {
        ArrayList<DateInfo> dateInfoList = new ArrayList<DateInfo>(4);
        DateInfo di = null;
        for (Combination combination : this.combinationList) {
            di = combination.getDateInfo();
            if (di == null) continue;
            dateInfoList.add(di);
        }
        if (!dateInfoList.isEmpty()) {
            Collections.sort(dateInfoList);
            return (DateInfo)dateInfoList.get(dateInfoList.size() - 1);
        }
        return null;
    }

    public static final class Combination {
        private List<RecordInfo> recordInfoList;
        private DateInfo dateInfo;

        public Combination() {
        }

        public Combination(List<RecordInfo> recordInfoList) {
            this.recordInfoList = recordInfoList;
            this.setDateInfo();
        }

        public List<RecordInfo> getRecordInfoList() {
            return this.recordInfoList;
        }

        public DateInfo getDateInfo() {
            return this.dateInfo;
        }

        private void setDateInfo() {
            ArrayList<DateInfo> dateInfoList = new ArrayList<DateInfo>(4);
            for (RecordInfo recordInfo : this.recordInfoList) {
                if (recordInfo.getDateInfo() == null) continue;
                dateInfoList.add(recordInfo.getDateInfo());
            }
            if (!dateInfoList.isEmpty()) {
                Collections.sort(dateInfoList);
                this.dateInfo = (DateInfo)dateInfoList.get(dateInfoList.size() - 1);
            }
        }
    }
}

