/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.processor;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.interfaces.IRecordContentProcessor;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;

public class PrimarySearchRecordContentProcessor
implements IRecordContentProcessor {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PrimarySearchRecordContentProcessor.class);
    private List<Rule> ruleList;
    private RuleMatchResultCache cache;

    public PrimarySearchRecordContentProcessor(List<Rule> ruleList, RuleMatchResultCache cache) {
        this.ruleList = ruleList;
        this.cache = cache;
    }

    @Override
    public void process(CharSequence recordContent, int lineNumber, File file, DeviceType deviceType) {
        block2: for (Rule rule : this.ruleList) {
            try {
                List<MatchCommand> matchCommandList = rule.getMatchCommandList();
                for (MatchCommand matchCommand : matchCommandList) {
                    if (!matchCommand.isMatch(recordContent)) continue block2;
                }
                RecordInfo recordInfo = new RecordInfo();
                recordInfo.setContent(recordContent);
                recordInfo.setFilePath(file.getCanonicalPath());
                recordInfo.setRuleId(rule.getId());
                recordInfo.setLineNumber(lineNumber);
                this.cache.add(recordInfo, deviceType);
            }
            catch (Exception e) {
                LOGGER.error("Searching rule occor an error:" + rule, (Throwable)e);
            }
        }
    }
}

