/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.util;

import com.huawei.ism.tool.loganalyzer.faulttree.exception.XmlParseException;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Dom4jParser {
    public static Document getDocument(File xmlFile) {
        try {
            return new SAXReader().read(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlParseException("Parse xml fail:" + xmlFile.getAbsolutePath(), e);
        }
    }

    public static Document getDocument(InputStream in) {
        try {
            Document document = new SAXReader().read(in);
            return document;
        }
        catch (Exception e) {
            throw new XmlParseException("Parse xml fail", e);
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }

    public static List<Element> getElementList(Element el, String nodeName) {
        return el.elements(nodeName);
    }

    public static List<Element> getElementList(Element el) {
        return el.elements();
    }
}

