/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.util;

import java.io.File;
import org.slf4j.LoggerFactory;

public class FileUtil {
    public static final String getFilePath(File f) {
        String path = null;
        try {
            path = f.getCanonicalPath();
        }
        catch (Exception e) {
            try {
                path = f.getAbsolutePath();
            }
            catch (Exception e2) {
                LoggerFactory.getLogger(FileUtil.class).error("Get File Absolute Path Error !");
                return "";
            }
        }
        if (f.isDirectory() && !path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static long getDirSize(File dir) {
        if (dir == null) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return 0L;
        }
        long dirSize = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    dirSize += file.length();
                } else if (file.isDirectory()) {
                    dirSize += file.length();
                    dirSize += FileUtil.getDirSize(file);
                }
                ++n2;
            }
        }
        return dirSize;
    }
}

