/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.util;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class IOUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(IOUtils.class);
    private static final int INT_0XFE = 254;
    private static final int INT_0XEF = 239;
    private static final int INT_0XBB = 187;
    private static final int INT_0XBF = 191;
    private static final int INT_0XC0 = 192;
    private static final int INT_0XDF = 223;
    private static final int INT_0XEO = 224;

    public static void close(Closeable ... cs) {
        if (cs != null) {
            Closeable[] closeableArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable closeable = closeableArray[n2];
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close io error:", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public static void close(Closeable cs) {
        if (cs != null) {
            try {
                cs.close();
            }
            catch (IOException e) {
                LOGGER.error("Close io error:", (Throwable)e);
            }
        }
    }

    public static String getFilecharset(File sourceFile) {
        boolean checked;
        BufferedInputStream bis;
        byte[] first3Bytes;
        String charset;
        block10: {
            charset = "GBK";
            first3Bytes = new byte[3];
            bis = null;
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
            checked = false;
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read != -1) break block10;
            String string = charset;
            IOUtils.close((Closeable)bis);
            return string;
        }
        try {
            try {
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = "UTF-8";
                    checked = true;
                }
                bis.reset();
                charset = IOUtils.checkCharset(charset, bis, checked);
            }
            catch (IOException e) {
                LOGGER.error("GetFilecharset is error:", (Throwable)e);
                IOUtils.close((Closeable)bis);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bis);
            throw throwable;
        }
        IOUtils.close((Closeable)bis);
        return charset;
    }

    private static String checkCharset(String charset, BufferedInputStream bis, boolean checked) throws IOException {
        if (!checked) {
            charset = IOUtils.checkBis(charset, bis);
        }
        return charset;
    }

    private static String checkBis(String charset, BufferedInputStream bis) throws IOException {
        int read;
        while ((read = bis.read()) != -1) {
            if (read >= 240 || 128 <= read && read <= 191) break;
            if (192 <= read && read <= 223) {
                read = bis.read();
                if (128 > read || read > 191) break;
                continue;
            }
            if (224 > read || read > 239) continue;
            List<Object> result = IOUtils.checkUTF(bis);
            boolean isUTF = (Boolean)result.get(0);
            charset = (String)result.get(1);
            if (!isUTF) break;
        }
        return charset;
    }

    private static List<Object> checkUTF(BufferedInputStream bis) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>(2);
        int read = bis.read();
        String charset = "GBK";
        if (128 <= read && read <= 191) {
            read = bis.read();
            if (128 <= read && read <= 191) {
                charset = "UTF-8";
                result.add(false);
            } else {
                result.add(false);
            }
        } else {
            result.add(false);
        }
        result.add(charset);
        return result;
    }
}

