/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.versionsearch;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Model;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.VersionSearcherUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.enumer.VersionExcludeFile;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.enumer.VersionIncludeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;

public class ProductInfo {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ProductInfo.class);
    private List<File> targetFileList = new ArrayList<File>();
    private String logFileName;
    private String model;
    private String version;
    private String sysName;
    private String sn;
    private String softVersion;

    public ProductInfo() {
    }

    public ProductInfo(File logRootDir) {
        this.divideFileType(logRootDir);
        this.doSearch();
    }

    private void doSearch() {
        Model m;
        VersionIncludeFile[] versionIncludeFileArray = VersionIncludeFile.values();
        int n = versionIncludeFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionIncludeFile versionFile = versionIncludeFileArray[n2];
            for (File file : this.targetFileList) {
                if (!file.getName().toLowerCase(Locale.ENGLISH).contains(versionFile.getName())) continue;
                if (this.model != null && this.version != null && this.version.toLowerCase(Locale.ENGLISH).contains("spc") && this.sysName != null && this.sn != null) {
                    return;
                }
                StringBuilder content = this.readFileContent(file);
                this.setModel(content);
                this.setVersion(content);
                this.setSysName(content);
                this.setSn(content);
            }
            ++n2;
        }
        boolean isMatchFlag = false;
        if (this.model != null && this.version != null && (m = DeviceType.getModel(this.model)).validVersion(this.version)) {
            isMatchFlag = true;
        }
        if (!isMatchFlag) {
            this.model = null;
            this.version = null;
        }
    }

    public void divideFileType(File folder) {
        File[] rootFiles = folder.listFiles();
        if (rootFiles == null || rootFiles.length == 0) {
            return;
        }
        File[] fileArray = rootFiles;
        int n = rootFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (!VersionExcludeFile.isExcluded(file.getName())) {
                    this.divideFileType(file);
                }
            } else if (VersionIncludeFile.isInclude(file.getName())) {
                this.targetFileList.add(file);
            }
            ++n2;
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(StringBuilder content) {
        Model m;
        String mod;
        if (this.model == null && (mod = VersionSearcherUtil.searchModel(content)) != null && (m = DeviceType.getModel(mod = mod.replace("_", " "))) != null) {
            this.model = m.getName();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(StringBuilder content) {
        if (this.version == null || !this.version.toLowerCase(Locale.ENGLISH).contains("spc")) {
            Model mod;
            String ver = VersionSearcherUtil.searchVersion(content);
            boolean isMatchFlag = false;
            if (this.model != null && ver != null && (mod = DeviceType.getModel(this.model)).validVersion(ver)) {
                isMatchFlag = true;
            }
            if (ver != null && (this.version != null && ver.toLowerCase(Locale.ENGLISH).contains("spc") || this.version == null) && (isMatchFlag || this.model == null)) {
                this.version = ver;
            }
        }
    }

    public void setMod(String model) {
        this.model = model;
    }

    public void setVer(String version) {
        this.version = version;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setSysName(StringBuilder content) {
        String systemName;
        if (this.sysName == null && (systemName = VersionSearcherUtil.searchSysName(content)) != null) {
            this.sysName = systemName;
        }
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(StringBuilder content) {
        String snNo;
        if (this.sn == null && (snNo = VersionSearcherUtil.searchSn(content)) != null) {
            this.sn = snNo;
        }
    }

    public String getSoftVersion() {
        return this.softVersion;
    }

    public void setSoftVersion(String softVersion) {
        this.softVersion = softVersion;
    }

    private StringBuilder readFileContent(File file) {
        StringBuilder content;
        block6: {
            FileInputStream fileInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            String line = null;
            content = new StringBuilder();
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    in = new InputStreamReader((InputStream)fileInputStream, IOUtils.getFilecharset(file));
                    reader = new BufferedReader(in);
                    while ((line = reader.readLine()) != null) {
                        content.append(line);
                        content.append('\n');
                    }
                }
                catch (Exception e) {
                    LOGGER.error("load config error: ", (Throwable)e);
                    IOUtils.close(reader, in, fileInputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(reader, in, fileInputStream);
                throw throwable;
            }
            IOUtils.close(reader, in, fileInputStream);
        }
        return content;
    }

    public String toString() {
        return "ProductInfo [model=" + this.model + ", version=" + this.version + ", sysName=" + this.sysName + ", sn=" + this.sn + ", softVersion=" + this.softVersion + "]";
    }
}

