/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.templet;

import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ProductVersionSearcher {
    private static Pattern patchVersionPattern;

    static {
        StringBuilder regexpBuilder = new StringBuilder();
        regexpBuilder.append(" *");
        regexpBuilder.append("((Patch Version))");
        regexpBuilder.append(" *(:|=|\\|)");
        regexpBuilder.append(" *");
        regexpBuilder.append("SPC\\d+ *(SPH\\d+)*");
        patchVersionPattern = Pattern.compile(regexpBuilder.toString());
    }

    public abstract String search(CharSequence var1);

    public String getVersion(CharSequence content, String curVersion) {
        String patchVersion;
        if (!(curVersion = curVersion.trim()).contains("SPC") && (patchVersion = this.getPatchVersion(content)) != null) {
            curVersion = String.valueOf(curVersion) + patchVersion;
        }
        return curVersion;
    }

    private String getPatchVersion(CharSequence content) {
        String[] versionInfo;
        Matcher m = MatcherUtils.match(content, patchVersionPattern);
        if (m != null && (versionInfo = m.group().trim().split("(:|=|\\|)")[1].trim().split(" +")).length > 0) {
            return versionInfo[0].trim();
        }
        return null;
    }
}

