/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.version;

import com.huawei.ism.tool.loganalyzer.entity.config.RuleFileConfig;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.templet.ProductVersionSearcher;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LoadRuleFileConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionInfo1Searcher
extends ProductVersionSearcher {
    private static final List<String> VERMAPSPCVERSIONS = new ArrayList<String>();
    private Pattern pattern;

    static {
        for (RuleFileConfig config : LoadRuleFileConfig.getInstance().getConfigs()) {
            if (config.getVermapSpcVersions() == null) continue;
            VERMAPSPCVERSIONS.addAll(config.getVermapSpcVersions());
        }
    }

    public VersionInfo1Searcher() {
        StringBuilder regexpBuilder = new StringBuilder();
        regexpBuilder.append("(Version)");
        regexpBuilder.append("(:|=|\\|)");
        regexpBuilder.append("([\\dA-Za-z\\.]+)");
        this.pattern = Pattern.compile(regexpBuilder.toString());
    }

    @Override
    public String search(CharSequence content) {
        String[] versionInfo;
        Matcher m = MatcherUtils.match(content, this.pattern);
        if (m != null && (versionInfo = m.group().trim().split("(:|=|\\|)")).length > 1) {
            String versionKey = versionInfo[1].trim();
            String result = "";
            int i = 0;
            while (i < VERMAPSPCVERSIONS.size()) {
                if (VERMAPSPCVERSIONS.get(i).contains(versionKey)) {
                    result = VERMAPSPCVERSIONS.get(i);
                    return result.split("=").length > 1 ? result.split("=")[1] : "";
                }
                ++i;
            }
        }
        return null;
    }
}

