/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeType;
import com.huawei.ism.tool.loganalyzer.entity.AnalyzeUserOpData;
import com.huawei.ism.tool.loganalyzer.entity.MatchCause;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.ProductInfo;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class AnalyzeUserOpService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AnalyzeUserOpService.class);
    private static Map<String, List<AnalyzeUserOpData>> analyzeUserRecordMap = new HashMap<String, List<AnalyzeUserOpData>>();

    public Map<String, List<AnalyzeUserOpData>> getAnalyzeUserRecordContainer() {
        return analyzeUserRecordMap;
    }

    public static void saveAnalyzeUserOpData() {
        for (List<AnalyzeUserOpData> userOpData : analyzeUserRecordMap.values()) {
            UserOpDataSaveUtil.batchSaveUserOpdata(userOpData);
        }
    }

    public static AnalyzeUserOpData getLogPackageUserOpData(LogRow row) {
        List<AnalyzeUserOpData> logPackageOpData = analyzeUserRecordMap.get(row.getLogFile().getName());
        if (logPackageOpData == null || logPackageOpData.isEmpty()) {
            return new AnalyzeUserOpData();
        }
        return logPackageOpData.get(logPackageOpData.size() - 1);
    }

    public static void preAnalyzeRecord(LogRow row) {
        try {
            File logFile = row.getLogFile();
            String packageName = logFile.getName();
            AnalyzeUserOpData userOpData = new AnalyzeUserOpData();
            userOpData.setProxyWay("");
            userOpData.setAuthWay("");
            userOpData.setDeviceType(row.getType());
            userOpData.setDeviceVersion(row.getVersion());
            ProductInfo pInfo = row.getProductInfo();
            String sn = "NA";
            if (pInfo != null && !StringUtils.isNULLStr((String)pInfo.getSn())) {
                sn = pInfo.getSn();
            }
            userOpData.setDeviceSn(sn);
            userOpData.setPackageName(packageName);
            double packageSize = new BigDecimal(logFile.length()).divide(new BigDecimal(0x100000)).doubleValue();
            DecimalFormat format = new DecimalFormat("#.##");
            userOpData.setPackageSize(String.valueOf(format.format(packageSize)) + "MB");
            AnalyzeUserOpService.setAnalyzeType(userOpData);
            long analyzeStartTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
            userOpData.setTaskStartTime(analyzeStartTime);
            List<AnalyzeUserOpData> packageUserOpData = analyzeUserRecordMap.get(packageName);
            if (packageUserOpData == null || packageUserOpData.isEmpty()) {
                packageUserOpData = new ArrayList<AnalyzeUserOpData>();
                analyzeUserRecordMap.put(packageName, packageUserOpData);
            }
            packageUserOpData.add(userOpData);
        }
        catch (Exception e) {
            LOGGER.error("something wrong about previous users' operation record occured", (Throwable)e);
        }
    }

    private static void setAnalyzeType(AnalyzeUserOpData userOpData) {
        int dateType = SearchConstant.getInstant().getDateType();
        if (dateType == 0) {
            userOpData.setAnalyzeType(AnalyzeType.PERIOD);
        } else if (dateType == 1) {
            userOpData.setAnalyzeType(AnalyzeType.DAY);
        } else {
            userOpData.setAnalyzeType(AnalyzeType.ALL);
        }
    }

    public static void afterAnalyzeRecord(LogRow row) {
        try {
            List<ReportLog> diagnoseInfoLogs;
            List<ReportLog> alarmInfoLogs;
            AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(row);
            List<ReportLog> faultTreeCauseLogs = row.getFaultTreeCauseLogs();
            if (faultTreeCauseLogs != null && !faultTreeCauseLogs.isEmpty()) {
                userOpData.setMatchCauseNum(faultTreeCauseLogs.size());
                List<MatchCause> matchCauseList = userOpData.getMatchCause();
                for (ReportLog reportLog : faultTreeCauseLogs) {
                    if (reportLog == null) continue;
                    matchCauseList.add(new MatchCause(reportLog.getName()));
                }
            }
            if ((alarmInfoLogs = row.getAlarmInfoLogs()) != null && !alarmInfoLogs.isEmpty()) {
                userOpData.setAlarmNum(alarmInfoLogs.size());
                for (ReportLog report : alarmInfoLogs) {
                    userOpData.addAlarmId(report.getId());
                }
            }
            if ((diagnoseInfoLogs = row.getDiagnoseInfoLogs()) != null && !diagnoseInfoLogs.isEmpty()) {
                userOpData.setDiagnoseNum(diagnoseInfoLogs.size());
                for (ReportLog report : diagnoseInfoLogs) {
                    userOpData.addDiagnoseId(report.getId());
                }
            }
            userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
            userOpData.setAnalyzeTime();
        }
        catch (Exception e) {
            LOGGER.error("something wrong about after users' operation record occured", (Throwable)e);
        }
    }

    public static void stopAnalyzeRecord(LogRow row) {
        AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(row);
        userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        userOpData.resetLogResult();
        userOpData.setAnalyzeTime();
    }

    public static void failedAnalyzeRecord(LogRow row) {
        AnalyzeUserOpData userOpData = AnalyzeUserOpService.getLogPackageUserOpData(row);
        userOpData.setTaskResult(UserOpTaskResult.FAILED);
        userOpData.resetLogResult();
        userOpData.setAnalyzeTime();
    }
}

