/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configloader;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.PythonRule;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ResultViewInfo;
import com.huawei.ism.tool.loganalyzer.entity.config.OldRule;
import com.huawei.ism.tool.loganalyzer.entity.config.Param;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.Cause;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroup;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.Pheno;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.PhenoNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalyzeRulesReader {
    private static final String SCRIPT = "script";

    public List<PythonRule> parsePythonRuleFile(File xmlPyRuleFile, LogRow row) throws ToolException {
        ArrayList<PythonRule> pythonRules = new ArrayList<PythonRule>();
        DeviceType type = DeviceType.type(row.getProductInfo().getModel());
        if (!xmlPyRuleFile.exists()) {
            return pythonRules;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(xmlPyRuleFile);
            Document doc = XmlUtils.parseDocument((InputStream)fileInputStream);
            if (doc == null) {
                ArrayList<PythonRule> arrayList = pythonRules;
                return arrayList;
            }
            try {
                Element rootEle = doc.getDocumentElement();
                Collection rlEles = XmlUtils.getChildren((Element)rootEle, (String)"rule");
                for (Element ruleEle : rlEles) {
                    PythonRule rule = new PythonRule();
                    Element scriptEles = XmlUtils.getChild((Element)ruleEle, (String)"python_script");
                    String ruleId = XmlUtils.getAttribute((Element)ruleEle, (String)"id");
                    ResultViewInfo viewInfo = null;
                    if (!StringUtils.isNULLStr((String)ruleId)) {
                        viewInfo = this.getResultById(ruleId, xmlPyRuleFile, type);
                    } else {
                        Element showsEles = XmlUtils.getChild((Element)ruleEle, (String)"show_infos");
                        viewInfo = this.getResultViewInfo(showsEles);
                        viewInfo.getParams().addAll(this.getParaResultViewInfo(showsEles));
                    }
                    rule.setId(ruleId);
                    rule.setResultViewInfo(viewInfo);
                    String fileNameString = this.getAttributeByName(scriptEles, "file");
                    rule.setPythonFile(new File(xmlPyRuleFile.getParentFile(), SCRIPT + File.separator + fileNameString));
                    rule.setExeMethod(this.getAttributeByName(scriptEles, "method"));
                    rule.setProduvtModel(xmlPyRuleFile.getParentFile().getName());
                    OldRule tmpRule = new OldRule();
                    tmpRule = this.parseByVersion(ruleEle, tmpRule, LoganalyzerContext.getInstance().getSoftwareVersion(), row);
                    if (tmpRule == null) continue;
                    pythonRules.add(rule);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Parse python rule file failed.", (Throwable)e);
                throw new ToolException("info.analyze.config.parser.error", (Throwable)e);
            }
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
        }
        return pythonRules;
    }

    private List<String> parsePythonRule(File xmlPyRuleFile) {
        ArrayList<String> ruleIds = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(xmlPyRuleFile);
            Document doc = XmlUtils.parseDocument((InputStream)fileInputStream);
            if (doc == null) {
                ArrayList<String> arrayList = ruleIds;
                return arrayList;
            }
            try {
                Element rootEle = doc.getDocumentElement();
                Collection rlEles = XmlUtils.getChildren((Element)rootEle, (String)"rule");
                for (Element ruleEle : rlEles) {
                    String ruleId = XmlUtils.getAttribute((Element)ruleEle, (String)"id");
                    ruleIds.add(ruleId);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Parse python rule file failed.", (Throwable)e);
            }
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
        }
        return ruleIds;
    }

    private void getXmlPyRuleFiles(File dir, List<File> xmlPyRuleFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File xmlPyRuleFile = new File(file, "AnalyzeRule_Python.xml");
            if (xmlPyRuleFile.exists()) {
                xmlPyRuleFiles.add(xmlPyRuleFile);
            }
            ++n2;
        }
    }

    public void parsePythonRuleFiles() {
        String confPath = String.valueOf(ApplicationContext.getInstance().getWorkPath()) + File.separator + "packages" + File.separator + "AnalyzeLogTool" + File.separator + "products";
        File dir = new File(confPath);
        ArrayList<File> xmlPyRuleFiles = new ArrayList<File>();
        this.getXmlPyRuleFiles(dir, xmlPyRuleFiles);
        Pheno pheno = DeviceType.UNIFINED.faultTypeCache().getPheno("08_01_01");
        if (pheno == null) {
            throw new PhenoNotFoundException("Can't find the pheno by phenoId:08_01_01");
        }
        CauseGroup causeGroup = new CauseGroup("08_01_01_20");
        for (File file : xmlPyRuleFiles) {
            List<String> ruleIds = this.parsePythonRule(file);
            for (String ruleId : ruleIds) {
                this.getResultById(ruleId, file, DeviceType.UNIFINED);
                Cause cause = new Cause(ruleId);
                cause.setGroupId(causeGroup.getId());
                if (causeGroup.getCauseList().contains(cause)) continue;
                causeGroup.add(cause);
            }
        }
        DeviceType.UNIFINED.causeGroupCache().get("08_01_01").addCauseGroup(causeGroup);
    }

    private ResultViewInfo getResultViewInfo(Element showsEles) {
        ResultViewInfo viewInfo = new ResultViewInfo();
        String[] stringArray = new String[]{"issue_no", "issue_desc", "issue_ver", "root_cause", "action", "prod_list", "helphref"};
        Collection showInfoEles = XmlUtils.getChildren((Element)showsEles, (String)"show_info");
        Locale lan = LanguageManager.getInstance().getCurrentLanguage();
        boolean isEqualEN = "en".equals(lan.toString());
        boolean isEqualZH = "zh_CN".equals(lan.toString());
        String valueTitle = null;
        if (isEqualEN) {
            valueTitle = "value_en";
        }
        if (isEqualZH) {
            valueTitle = "value";
        }
        int i = 0;
        while (i < stringArray.length) {
            for (Element showEle : showInfoEles) {
                String name = XmlUtils.getAttribute((Element)showEle, (String)"name");
                if (!stringArray[i].equals(name)) continue;
                String value = XmlUtils.getAttribute((Element)showEle, (String)valueTitle);
                if (StringUtils.isNULLStr((String)value)) {
                    value = XmlUtils.getAttribute((Element)showEle, (String)"value");
                }
                KeyValue keyv = new KeyValue((Object)name, (Object)value);
                viewInfo.getViewInfos().add((KeyValue<String, String>)keyv);
                break;
            }
            ++i;
        }
        return viewInfo;
    }

    private ResultViewInfo getResultById(String id, File xmlRuleFile, DeviceType type) {
        ResultViewInfo viewInfo = new ResultViewInfo();
        String[] stringArray = new String[]{"issue_no", "issue_desc", "issue_ver", "root_cause", "action", "prod_list", "helphref"};
        String[] faultTreeKeys = new String[]{"issue.no", "issue.name", "issue.version", "issue.cause", "issue.action", "issue.model", "issue.case.href", "issue.case.name"};
        ResourceBundle bundle = this.readProperties(xmlRuleFile.getParentFile());
        if (bundle == null) {
            return null;
        }
        int index = 0;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key = stringArray2[n2];
            try {
                value = bundle.getString(String.valueOf(id) + "." + key);
                if (key.equals("helphref")) {
                    String[] spiltResult = SearcherUtils.splitHelpHref(value);
                    if (spiltResult[0] != null && spiltResult[1] != null) {
                        type.resourceCache().put(String.valueOf(id) + "." + faultTreeKeys[index], spiltResult[0]);
                        type.resourceCache().put(String.valueOf(id) + "." + faultTreeKeys[index + 1], spiltResult[1]);
                    }
                } else {
                    type.resourceCache().put(String.valueOf(id) + "." + faultTreeKeys[index], value);
                }
                ++index;
            }
            catch (Exception e) {
                value = null;
                ToolLoggerFactory.getLogger(this.getClass()).error("get key" + key + "with vaule failed", (Throwable)e);
            }
            if (!StringUtils.isNULLStr((String)value)) {
                KeyValue keyv = new KeyValue((Object)key, (Object)value);
                viewInfo.getViewInfos().add((KeyValue<String, String>)keyv);
            }
            ++n2;
        }
        viewInfo.getViewInfos().add((KeyValue<String, String>)new KeyValue((Object)"rule_id", (Object)id));
        return viewInfo;
    }

    private Collection<Param> getParaResultViewInfo(Element showsEles) {
        ArrayList<Param> paramList = new ArrayList<Param>();
        Element params = XmlUtils.getChild((Element)showsEles, (String)"params");
        if (params == null) {
            return paramList;
        }
        Collection paramEles = XmlUtils.getChildren((Element)params, (String)"param");
        for (Element pe : paramEles) {
            Param param = new Param();
            param.setFromInfoId(XmlUtils.getAttribute((Element)pe, (String)"from_infoid"));
            param.setParamName(XmlUtils.getAttribute((Element)pe, (String)"name"));
            param.setValue(XmlUtils.getAttribute((Element)pe, (String)"value"));
            String type = XmlUtils.getAttribute((Element)pe, (String)"type");
            if ("expression".equals(type)) {
                param.setType(2);
            } else if ("column".equals(type)) {
                param.setType(1);
            }
            paramList.add(param);
        }
        return paramList;
    }

    private OldRule parseByVersion(Element ruleEle, OldRule rule, String softwareVersion, LogRow row) {
        rule = this.getVersionToRule(rule, softwareVersion);
        String productNumberInfo = XmlUtils.getAttribute((Element)ruleEle, (String)"prod_name");
        String productVersionInfo = XmlUtils.getAttribute((Element)ruleEle, (String)"prod_ver");
        String[] prductNumbers = null;
        String[] productVersions = null;
        prductNumbers = productNumberInfo != null ? productNumberInfo.split("\\|") : null;
        productVersions = productVersionInfo != null ? productVersionInfo.split("\\|") : null;
        String versionNumber = rule.getVersionNumber();
        String inputVersion = row.getProductInfo().getVersion();
        if (prductNumbers == null) {
            return this.isAllowVersion(productVersions, inputVersion, versionNumber) ? rule : null;
        }
        String[] stringArray = prductNumbers;
        int n = prductNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String productNumber = stringArray[n2];
            if (productNumber.equals(row.getRow().getValueAt(1).toString()) && this.isAllowVersion(productVersions, inputVersion, versionNumber)) {
                return rule;
            }
            ++n2;
        }
        return null;
    }

    private boolean isAllowVersion(String[] productVersions, String inputVersion, String versionNumber) {
        if (productVersions == null) {
            return true;
        }
        return this.isInScope(productVersions, StringUtils.isNULLStr((String)versionNumber) ? inputVersion : versionNumber);
    }

    private boolean isInScope(String[] productVersions, String targetVersion) {
        boolean isAllowFlag = false;
        targetVersion = targetVersion.split("B")[0].split("T")[0];
        String[] stringArray = productVersions;
        int n = productVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String productVersion = stringArray[n2];
            String[] ss = productVersion.split(",");
            if (ss.length > 1 && targetVersion.length() == ss[0].length() && targetVersion.length() == ss[1].length()) {
                ArrayList<String> versions = new ArrayList<String>();
                versions.add(targetVersion);
                versions.addAll(Arrays.asList(productVersion.split(",")));
                Collections.sort(versions);
                if (targetVersion.equals(versions.get(1))) {
                    isAllowFlag = true;
                    break;
                }
            }
            ++n2;
        }
        return isAllowFlag;
    }

    private OldRule getVersionToRule(OldRule rule, String softwareVersion) {
        if (StringUtils.isNULLStr((String)softwareVersion)) {
            ToolLoggerFactory.getLogger(this.getClass()).debug("Config to fail.");
            return rule;
        }
        File file = new File(LoganalyzerContext.getInstance().getDataworkbookPath());
        if (!file.exists()) {
            return rule;
        }
        try {
            IniReader reader = new IniReader(file);
            String info = reader.getString(softwareVersion);
            String[] infos = info != null ? info.split("\\|") : null;
            String versionNumber = infos != null ? infos[0] : null;
            rule.setSoftwareVersion(softwareVersion);
            rule.setVersionNumber(versionNumber);
            return rule;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Get version failed.", (Throwable)e);
            return rule;
        }
    }

    private String getAttributeByName(Element root, String target) {
        String reslutString = "";
        Collection rlEles = XmlUtils.searchByExp2Ele((Node)root, (String)target);
        for (Element rlEle : rlEles) {
            reslutString = XmlUtils.getAttribute((Element)rlEle, (String)"name");
            if (StringUtils.isNULLStr((String)reslutString)) break;
        }
        return reslutString;
    }

    private ResourceBundle readProperties(File propertiesPath) {
        PropertyResourceBundle bundle;
        block6: {
            String currentLanguage = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
            StringBuffer propertiesName = new StringBuffer();
            propertiesName.append("res").append(File.separator).append("resource_").append(currentLanguage).append(".properties");
            File propertiesFile = new File(propertiesPath, propertiesName.toString());
            if (!propertiesFile.exists()) {
                return null;
            }
            bundle = null;
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(propertiesFile));
                    bundle = new PropertyResourceBundle(input);
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("Read properties failed.", (Throwable)e);
                    StreamUtils.closeStream(null, (InputStream)input);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, input);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)input);
        }
        return bundle;
    }
}

