/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configloader;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.config.ConfigInfoRule;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigInfoReader {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ConfigInfoReader.class);

    public static void getConfigRule(ConfigInfoRule configRule) {
        Document doc = ConfigInfoReader.getDocument();
        if (doc == null) {
            return;
        }
        configRule.setSkipLineKey(Arrays.asList(ConfigInfoReader.getProperty("skipLine", configRule, doc).split(",")));
        ConfigInfoReader.setConfigIncludeKeys(configRule, doc);
        ConfigInfoReader.setConfigExcludeKeys(configRule, doc);
    }

    public static void getClicmdRule(ConfigInfoRule clicmdRule) {
        Document doc = ConfigInfoReader.getDocument();
        if (doc != null) {
            clicmdRule.setSkipLineKey(Arrays.asList(ConfigInfoReader.getProperty("skipLine", clicmdRule, doc).split(",")));
            ConfigInfoReader.setClicmdIncludeKeys(clicmdRule, doc);
            ConfigInfoReader.setClicmdExcludeKeys(clicmdRule, doc);
        }
    }

    private static void setConfigIncludeKeys(ConfigInfoRule configInfoRule, Document doc) {
        configInfoRule.setBasicInfoKey(Arrays.asList(ConfigInfoReader.getProperty("setting.basicInformation.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setControllerEncKey(Arrays.asList(ConfigInfoReader.getProperty("system.controllerEnclosure.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setDiskDomainKey(Arrays.asList(ConfigInfoReader.getProperty("resource.diskDomain.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setDiskEncKey(Arrays.asList(ConfigInfoReader.getProperty("system.diskEnclosure.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setHostKey(Arrays.asList(ConfigInfoReader.getProperty("resource.host.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setLicenseKey(Arrays.asList(ConfigInfoReader.getProperty("setting.licenseManagement.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setLunKey(Arrays.asList(ConfigInfoReader.getProperty("resource.LUN.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setMappingViewKey(Arrays.asList(ConfigInfoReader.getProperty("resource.mappingView.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setPortKey(Arrays.asList(ConfigInfoReader.getProperty("resource.port.key_config", configInfoRule, doc).split(",")));
        configInfoRule.setStoragePoolKey(Arrays.asList(ConfigInfoReader.getProperty("resource.storagePool.key_config", configInfoRule, doc).split(",")));
    }

    private static void setConfigExcludeKeys(ConfigInfoRule configInfoRule, Document doc) {
        configInfoRule.setBasicInfoExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("setting.basicInformation.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setControllerEncExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("system.controllerEnclosure.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setDiskDomainExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.diskDomain.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setDiskEncExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("system.diskEnclosure.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setHostExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.host.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setLicenseExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("setting.licenseManagement.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setLunExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.LUN.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setMappingViewExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.mappingView.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setPortExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.port.excludeKey_config", configInfoRule, doc).split(",")));
        configInfoRule.setStoragePoolExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.storagePool.excludeKey_config", configInfoRule, doc).split(",")));
    }

    private static void setClicmdIncludeKeys(ConfigInfoRule configInfoRule, Document doc) {
        configInfoRule.setBasicInfoKey(Arrays.asList(ConfigInfoReader.getProperty("setting.basicInformation.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setControllerEncKey(Arrays.asList(ConfigInfoReader.getProperty("system.controllerEnclosure.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setDiskDomainKey(Arrays.asList(ConfigInfoReader.getProperty("resource.diskDomain.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setDiskEncKey(Arrays.asList(ConfigInfoReader.getProperty("system.diskEnclosure.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setHostKey(Arrays.asList(ConfigInfoReader.getProperty("resource.host.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setLicenseKey(Arrays.asList(ConfigInfoReader.getProperty("setting.licenseManagement.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setLunKey(Arrays.asList(ConfigInfoReader.getProperty("resource.LUN.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setMappingViewKey(Arrays.asList(ConfigInfoReader.getProperty("resource.mappingView.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setPortKey(Arrays.asList(ConfigInfoReader.getProperty("resource.port.key_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setStoragePoolKey(Arrays.asList(ConfigInfoReader.getProperty("resource.storagePool.key_clicmd", configInfoRule, doc).split(",")));
    }

    private static void setClicmdExcludeKeys(ConfigInfoRule configInfoRule, Document doc) {
        configInfoRule.setBasicInfoExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("setting.basicInformation.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setControllerEncExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("system.controllerEnclosure.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setDiskDomainExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.diskDomain.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setDiskEncExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("system.diskEnclosure.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setHostExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.host.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setLicenseExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("setting.licenseManagement.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setLunExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.LUN.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setMappingViewExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.mappingView.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setPortExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.port.excludeKey_clicmd", configInfoRule, doc).split(",")));
        configInfoRule.setStoragePoolExcludeKey(Arrays.asList(ConfigInfoReader.getProperty("resource.storagePool.excludeKey_clicmd", configInfoRule, doc).split(",")));
    }

    public static Document getDocument() {
        InputStream softHardSettingFileInputStream = ConfigInfoReader.class.getResourceAsStream("/config/rule/configInformation.xml");
        Document doc = null;
        try {
            try {
                doc = XmlUtils.parseDocument((InputStream)softHardSettingFileInputStream);
            }
            catch (Exception e) {
                LOGGER.error("Parse rule file failed.", (Throwable)e);
                StreamUtils.closeResource(null, (Closeable)softHardSettingFileInputStream);
            }
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)softHardSettingFileInputStream);
        }
        return doc;
    }

    public static String getProperty(String name, ConfigInfoRule configInfoRule, Document doc) {
        String[] propName = name.split("\\.");
        Element element = doc.getDocumentElement();
        String[] stringArray = propName;
        int n = propName.length;
        int n2 = 0;
        while (n2 < n) {
            String keyName = stringArray[n2];
            if ((element = XmlUtils.getChild((Element)element, (String)keyName)) == null) {
                if (!name.contains("excludeKey")) {
                    StringBuilder parseErrorInfo = new StringBuilder(configInfoRule.getParseErrorInfo() == null ? "" : configInfoRule.getParseErrorInfo());
                    configInfoRule.setParseErrorInfo(parseErrorInfo.append("Not find Rule point\uff1a" + name + "\n").toString());
                }
                return "";
            }
            ++n2;
        }
        String value = element.getTextContent();
        if ("".equals(value)) {
            if (!name.contains("excludeKey")) {
                StringBuilder parseErrorInfo = new StringBuilder(configInfoRule.getParseErrorInfo() == null ? "" : configInfoRule.getParseErrorInfo());
                configInfoRule.setParseErrorInfo(parseErrorInfo.append("The Rule point\uff1a" + name + " not find content" + "\n").toString());
            }
            return "";
        }
        value = value.trim();
        return value;
    }

    public static boolean checkConfigInfoRule(ConfigInfoRule configInfoRule) {
        if (!StringUtils.isNULLStr((String)configInfoRule.getParseErrorInfo())) {
            LOGGER.error(configInfoRule.getParseErrorInfo());
            return false;
        }
        return true;
    }
}

