/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configloader;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.EventDetail;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.config.RuleFileConfig;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LoadRuleFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;

public class EventExcelReader {
    public static final String DOUBLERUNG = "--";
    private File xlsFile;
    private Map<String, Integer> evnetLocMap;

    public EventExcelReader(File xlsFile, Map<String, Integer> evnetLocMap) {
        this.xlsFile = xlsFile;
        this.evnetLocMap = evnetLocMap;
    }

    public List<EventDetail> resolveDeviceEntries(LogRow logRow, int packageNum) {
        ArrayList<EventDetail> eventDetails = new ArrayList<EventDetail>();
        try (Workbook workbook = null;){
            try {
                workbook = Workbook.getWorkbook((File)this.xlsFile);
                Sheet eventSheet = workbook.getSheet(packageNum);
                int rows = eventSheet.getRows();
                int startLine = 1;
                while (rows > startLine) {
                    String alarmID = eventSheet.getCell(this.evnetLocMap.get("alarmId").intValue(), startLine).getContents();
                    String eventNameZh = eventSheet.getCell(this.evnetLocMap.get("eventNameZh").intValue(), startLine).getContents();
                    String eventNameEn = eventSheet.getCell(this.evnetLocMap.get("eventNameEn").intValue(), startLine).getContents();
                    String eventDetailZh = eventSheet.getCell(this.evnetLocMap.get("eventDetailZh").intValue(), startLine).getContents();
                    String eventDetailEn = eventSheet.getCell(this.evnetLocMap.get("eventDetailEn").intValue(), startLine).getContents();
                    String eventCaseZh = eventSheet.getCell(this.evnetLocMap.get("eventCaseZh").intValue(), startLine).getContents();
                    String eventCaseEn = eventSheet.getCell(this.evnetLocMap.get("eventCaseEn").intValue(), startLine).getContents();
                    String suggestionZh = eventSheet.getCell(this.evnetLocMap.get("suggestionZh").intValue(), startLine).getContents();
                    String suggestionEn = eventSheet.getCell(this.evnetLocMap.get("suggestionEn").intValue(), startLine).getContents();
                    ++startLine;
                    if (this.isNull(alarmID)) continue;
                    EventDetail eventDetail = new EventDetail();
                    eventDetail.setAlarmID(alarmID);
                    eventDetail.setEventNameZh(StringUtils.isNULLStr((String)eventNameZh) ? DOUBLERUNG : eventNameZh);
                    eventDetail.setEventNameEn(StringUtils.isNULLStr((String)eventNameEn) ? DOUBLERUNG : eventNameEn);
                    eventDetail.setEventDetailZh(StringUtils.isNULLStr((String)eventDetailZh) ? DOUBLERUNG : eventDetailZh);
                    eventDetail.setEventDetailEn(StringUtils.isNULLStr((String)eventDetailEn) ? DOUBLERUNG : eventDetailEn);
                    eventDetail.setEventCaseZh(StringUtils.isNULLStr((String)eventCaseZh) ? DOUBLERUNG : eventCaseZh);
                    eventDetail.setEventCaseEn(StringUtils.isNULLStr((String)eventCaseEn) ? DOUBLERUNG : eventCaseEn);
                    eventDetail.setSuggestionZh(StringUtils.isNULLStr((String)suggestionZh) ? DOUBLERUNG : suggestionZh);
                    eventDetail.setSuggestionEn(StringUtils.isNULLStr((String)suggestionEn) ? DOUBLERUNG : suggestionEn);
                    RuleFileConfig config = LoadRuleFileConfig.getInstance().getProductName(String.valueOf(logRow.getProductInfo().getModel()) + logRow.getProductInfo().getVersion());
                    if (config != null) {
                        eventDetail.setVersion(config.getEventVersion());
                        eventDetail.setProList(config.getEventProlist());
                    }
                    eventDetails.add(eventDetail);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load EventDetail.xls failed", (Throwable)e);
                if (workbook != null) {
                    workbook.close();
                }
            }
        }
        return eventDetails;
    }

    private boolean isNull(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringUtils.isNULLStr((String)string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

