/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configloader;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ErrorCode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LoadErrorCode {
    private static final String XML_EN_NAME = "error_en.xml";
    private static final String XML_ZH_NAME = "error_zh.xml";
    private static final String ERROR = "errors/error";
    private static final String SUGGESTION = "suggestions/suggestion";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String REASON = "reason";
    private static LoadErrorCode instant;
    private static List<ErrorCode> errorCodes;
    private static File parentFile;

    static {
        errorCodes = new ArrayList<ErrorCode>();
    }

    private LoadErrorCode() {
        this.init();
    }

    public static synchronized LoadErrorCode getInstane() {
        if (instant == null) {
            instant = new LoadErrorCode();
        }
        return instant;
    }

    public static synchronized void clear() {
        errorCodes.clear();
        instant = null;
    }

    public static void setParentFile(File parent) {
        parentFile = parent;
    }

    private void init() {
        if (parentFile == null || !parentFile.exists()) {
            return;
        }
        File xmlFile = null;
        xmlFile = LanguageManager.getInstance().getCurrentLanguage().getLanguage().equals(Locale.ENGLISH.getLanguage()) ? new File(parentFile, XML_EN_NAME) : new File(parentFile, XML_ZH_NAME);
        if (!xmlFile.exists()) {
            return;
        }
        this.loadXmlFile(xmlFile);
    }

    private void loadXmlFile(File xml) {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(xml);
                Document doc = XmlUtils.parseDocument((InputStream)fileInputStream);
                Element root = doc.getDocumentElement();
                Collection rlEles = XmlUtils.searchByExp2Ele((Node)root, (String)ERROR);
                for (Element element : rlEles) {
                    ErrorCode errorCode = new ErrorCode();
                    errorCode.setId(XmlUtils.getAttribute((Element)element, (String)ID));
                    errorCode.setReason(this.loadReason(element));
                    errorCode.setSuggestion(this.loadSuggestion(element));
                    errorCodes.add(errorCode);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load xml file failed!", (Throwable)e);
                if (fileInputStream != null) {
                    StreamUtils.closeResource(null, (Closeable)fileInputStream);
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                StreamUtils.closeResource(null, (Closeable)fileInputStream);
            }
        }
    }

    private String loadReason(Element element) {
        String reason = "";
        Element res = XmlUtils.getChild((Element)element, (String)REASON);
        reason = XmlUtils.getAttribute((Element)res, (String)DESCRIPTION);
        return reason;
    }

    private String loadSuggestion(Element element) {
        StringBuffer suggestion = new StringBuffer();
        Collection sugEles = XmlUtils.searchByExp2Ele((Node)element, (String)SUGGESTION);
        int count = 0;
        for (Element el : sugEles) {
            suggestion.append(XmlUtils.getAttribute((Element)el, (String)DESCRIPTION));
            if (++count >= sugEles.size()) continue;
            suggestion.append("\n");
        }
        return suggestion.toString();
    }

    public ErrorCode getErrorCodeByID(String id) {
        for (ErrorCode tmpCode : errorCodes) {
            if (!id.equals(tmpCode.getId())) continue;
            return tmpCode;
        }
        return null;
    }
}

