/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configloader;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.config.ModulePIDInfoMap;
import com.huawei.ism.tool.loganalyzer.entity.config.PIDinfos;
import com.huawei.ism.tool.loganalyzer.util.ComponentDefine;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import jxl.Sheet;
import jxl.Workbook;

public class ModulePIDReader {
    private static final String EXCEL_FILE_PATH = String.valueOf(ComponentDefine.CONFIG_PATH) + "/common/modulePID/ModulePID.xls";
    private static final String SHEET_NAME = "moduleInfo";
    private static final String EQUAL_MARK = "=";
    private Workbook excelBook = null;

    public ModulePIDReader() {
        try {
            this.excelBook = Workbook.getWorkbook((File)new File(EXCEL_FILE_PATH));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("parse ModulePID.xls occor an error", (Throwable)e);
        }
    }

    public boolean readPidExcel() {
        boolean result = false;
        if (this.excelBook != null) {
            try {
                Sheet sheet = this.excelBook.getSheet(SHEET_NAME);
                if (sheet == null) {
                    boolean bl = result;
                    return bl;
                }
                try {
                    int i = 1;
                    while (i < sheet.getRows()) {
                        String pId = sheet.getCell(2, i).getContents().trim();
                        PIDinfos pIDinfo = this.parse(pId);
                        if (pIDinfo != null) {
                            String moudleName = sheet.getCell(3, i).getContents().trim();
                            this.setValue(moudleName, pIDinfo);
                        }
                        ++i;
                    }
                    result = true;
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("parse ModulePID.xls occor an error", (Throwable)e);
                    boolean bl = result;
                    return bl;
                }
            }
            finally {
                this.excelBook.close();
            }
        }
        return result;
    }

    private void setValue(String moudleName, PIDinfos pIDinfo) {
        if (StringUtils.isNULLStr((String)moudleName)) {
            int index = pIDinfo.getpIDValue().indexOf(95, 0);
            if (index != -1) {
                String moduleNa = pIDinfo.getpIDValue().substring(index + 1, pIDinfo.getpIDValue().length());
                ModulePIDInfoMap.put(pIDinfo.getpIDKey(), moduleNa);
            } else {
                ModulePIDInfoMap.put(pIDinfo.getpIDKey(), pIDinfo.getpIDValue());
            }
        } else {
            ModulePIDInfoMap.put(pIDinfo.getpIDKey(), moudleName);
        }
    }

    private PIDinfos parse(String pid) {
        PIDinfos pIDinfo = null;
        try {
            if (pid.contains(EQUAL_MARK)) {
                pIDinfo = new PIDinfos();
                String[] str = pid.split(EQUAL_MARK);
                if (str.length < 2) {
                    return pIDinfo;
                }
                String num = str[1].trim();
                String string = num = num.contains(",") ? num.substring(0, num.length() - 1) : num;
                if (!StringUtils.isNULLStr((String)num) && !StringUtils.isNULLStr((String)str[0])) {
                    pIDinfo.setpIDValue(str[0].trim());
                    pIDinfo.setpIDKey(num);
                }
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("parse ModulePID.xls occor an error", (Throwable)e);
        }
        return pIDinfo;
    }
}

