/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configsearcher;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.entity.config.ConfigInfoRule;
import com.huawei.ism.tool.loganalyzer.logic.configsearcher.FileSearcher;
import java.io.File;
import java.util.List;

public class ConfigFileSearcher
extends FileSearcher {
    @Override
    public ConfigInfoEntry doSearch(List<File> deCompressFiles) {
        this.setConfigInfoRule(ConfigInfoRule.getConfigRuleInstance());
        File configFile = this.findSearchFile(deCompressFiles, "Config");
        ConfigInfoEntry configInfoEntry = null;
        if (configFile != null) {
            configInfoEntry = this.searchSoftHardwareConfigInfo(this.getFileContent(configFile), "[a-zA-Z]+.*-+\\s*|\\s+License-+\\s*");
            configInfoEntry.setLicense(this.dealLicenseInfo(configInfoEntry.getLicense()));
        } else {
            LOGGER.info("Not Find Config File");
        }
        return configInfoEntry;
    }

    private String dealLicenseInfo(String licenseInfo) {
        if (!StringUtils.isNULLStr((String)licenseInfo)) {
            return licenseInfo.replaceAll("Detail:\n", "");
        }
        return null;
    }
}

