/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.configsearcher;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.entity.config.ConfigInfoRule;
import com.huawei.ism.tool.loganalyzer.logic.configloader.ConfigInfoReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;

public abstract class FileSearcher {
    public static final Logger LOGGER = ToolLoggerFactory.getLogger(ConfigInfoReader.class);
    private ConfigInfoRule configInfoRule;

    public abstract ConfigInfoEntry doSearch(List<File> var1);

    public List<String> getFileContent(File searchFile) {
        ArrayList<String> fileContent;
        block6: {
            FileInputStream fileInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            fileContent = new ArrayList<String>();
            try {
                try {
                    fileInputStream = new FileInputStream(searchFile);
                    in = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        fileContent.add(line);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("searchConfigInfo error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)fileInputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)fileInputStream);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
        }
        return fileContent;
    }

    public File findSearchFile(List<File> files, String fileName) {
        for (File file : files) {
            if (!this.containIgnoreCase(file.getName(), fileName)) continue;
            return file;
        }
        return null;
    }

    public boolean containIgnoreCase(String source, String containedString) {
        return source.toLowerCase(Locale.ENGLISH).contains(containedString.toLowerCase(Locale.ENGLISH));
    }

    public ConfigInfoEntry searchSoftHardwareConfigInfo(List<String> fileContent, String endFlag) {
        ConfigInfoEntry configInfoEntry = new ConfigInfoEntry();
        ConfigInfoRule configInfoRu = this.getConfigInfoRule();
        configInfoEntry.setBasicInfo(this.getSearchContent(fileContent, configInfoRu.getBasicInfoKey(), configInfoRu.getBasicInfoExcludeKey(), endFlag));
        configInfoEntry.setControllerEnc(this.getSearchContent(fileContent, configInfoRu.getControllerEncKey(), configInfoRu.getControllerEncExcludeKey(), endFlag));
        configInfoEntry.setDiskDomain(this.getSearchContent(fileContent, configInfoRu.getDiskDomainKey(), configInfoRu.getDiskDomainExcludeKey(), endFlag));
        configInfoEntry.setDiskEnc(this.getSearchContent(fileContent, configInfoRu.getDiskEncKey(), configInfoRu.getDiskEncExcludeKey(), endFlag));
        configInfoEntry.setHost(this.getSearchContent(fileContent, configInfoRu.getHostKey(), configInfoRu.getHostExcludeKey(), endFlag));
        configInfoEntry.setLun(this.getSearchContent(fileContent, configInfoRu.getLunKey(), configInfoRu.getLunExcludeKey(), endFlag));
        configInfoEntry.setLicense(this.getSearchContent(fileContent, configInfoRu.getLicenseKey(), configInfoRu.getLicenseExcludeKey(), endFlag));
        configInfoEntry.setMappingView(this.getSearchContent(fileContent, configInfoRu.getMappingViewKey(), configInfoRu.getMappingViewExcludeKey(), endFlag));
        configInfoEntry.setPort(this.getSearchContent(fileContent, configInfoRu.getPortKey(), configInfoRu.getPortExcludeKey(), endFlag));
        configInfoEntry.setStoragePool(this.getSearchContent(fileContent, configInfoRu.getStoragePoolKey(), configInfoRu.getStoragePoolExcludeKey(), endFlag));
        return configInfoEntry;
    }

    public String getSearchContent(List<String> fileContent, List<String> keys, List<String> excludeKeys, String endFlag) {
        StringBuffer info = new StringBuffer();
        int index = 0;
        String line = "";
        while (index < fileContent.size()) {
            line = fileContent.get(index);
            if (this.containsKeys(line, keys) && !this.containsKeys(line, excludeKeys) && line.trim().matches("^[a-zA-Z].*$")) {
                line = fileContent.get(++index);
                while (index < fileContent.size() && !line.matches(endFlag)) {
                    if (!this.containsKeys(line, this.getConfigInfoRule().getSkipLineKey())) {
                        info.append(line);
                        info.append("\n");
                    }
                    line = fileContent.get(++index);
                }
                --index;
            }
            ++index;
        }
        return info.toString();
    }

    public boolean containsKeys(String line, List<String> keys) {
        boolean flag = false;
        if (line != null && keys != null) {
            for (String key : keys) {
                if (StringUtils.isNULLStr((String)key) || !line.contains(key)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public ConfigInfoRule getConfigInfoRule() {
        return this.configInfoRule;
    }

    public void setConfigInfoRule(ConfigInfoRule configInfoRule) {
        this.configInfoRule = configInfoRule;
    }
}

