/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.Event;
import com.huawei.ism.tool.loganalyzer.entity.analyze.EventBaiscInfo;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.util.ComparatorUtils;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LogWorkTakerImpl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class AnalyzeEvent {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogWorkTakerImpl.class);
    private static final String HEAD_INFO_REGEX = "^((?!\\s{4,}).)*\\s{4}((?!\\s{4,}).)*\\s{4}((?!\\s{4,}).)*\\s{4}((?!\\s{4,}).)*\\s{4}((?!\\s{4,}).)*$";
    private static final String NO_SUGGESTION_LINE = "^((?!\\s{4,}).)*\\s{4}$";
    private static final String SUGGESTION_ON_MORE_LINES = "^[0-9]{4}-.*\\s{4}.*\\s{4}.*\\s{4}.*\\s{4}.*$";
    private static final String SUGGESTION_FOR_SEQUENCE = "^[0-9]*\\s{4}.*\\s{4}.*\\s{4}.*\\s{4}.*\\s{4}.*\\s{4}.*\\s{4}.*$";
    private static final String STARTBYDATA = "^[0-9]{4}.*$";
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int LOCAL_TIME = 0;
    private static final int ALARN_ID = 1;
    private static final int ALARM_LEVEL = 2;
    private static final int RECOVERED_LOCCAL_TIME = 3;
    private static final int DESCRIPTION = 4;
    private static final int SUGGESTION = 5;
    private static final String NOSUGGESTION = "N/A";
    private static final int CSEQUENCE = 0;
    private static final int CLOCAL_TIME = 1;
    private static final int CALARN_ID = 2;
    private static final int CEVENTTYPE = 3;
    private static final int CALARM_LEVEL = 4;
    private static final int CSTATE = 5;
    private static final int CRECOVERED_LOCCAL_TIME = 6;
    private static final int CDESCRIPTION = 7;
    private static final int CSUGGESTION = 8;
    private static final String INFOR_STRING = "INFOR";
    private static final String INFORNATION_STRING = "INFORMATIONAL";
    private static Pattern p = Pattern.compile("^[\\d\\- :]+");

    public Map<Long, List<Event>> doAnalyzeEvents(List<File> files, LogRow row) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (File controlEventFile : files) {
            List<Event> tmpEvents = this.doAnalyzeEvent(controlEventFile, row);
            events.addAll(tmpEvents);
        }
        Collections.sort(events, ComparatorUtils.DOANALYZEEVENTS_EVENT_TIME_SORT);
        String startTimeString = SearchConstant.getInstant().getStartTime();
        String endTimeString = SearchConstant.getInstant().getEndTime();
        long startTime = this.getStartTime(startTimeString);
        long endTime = this.getEndTime(endTimeString);
        return this.getNewAlarm(events, row, startTime, endTime);
    }

    private long getEndTime(String endTimeString) {
        long endTime = 0L;
        if (!StringUtils.isNULLStr((String)endTimeString)) {
            endTime = StringUtils.parseDate2Long((String)endTimeString, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (endTime == 0L) {
            endTime = Long.MAX_VALUE;
        }
        return endTime;
    }

    private long getStartTime(String startTimeString) {
        long startTime = 0L;
        if (!StringUtils.isNULLStr((String)startTimeString)) {
            startTime = StringUtils.parseDate2Long((String)startTimeString, (String)"yyyy-MM-dd HH:mm:ss");
        }
        return startTime;
    }

    private List<Event> doAnalyzeEvent(File evnet, LogRow row) {
        ArrayList<Event> events;
        block6: {
            events = new ArrayList<Event>();
            if (!evnet.exists()) {
                return events;
            }
            FileInputStream fileInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            try {
                try {
                    fileInputStream = new FileInputStream(evnet);
                    in = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    reader = this.readLineInfoToEvent(evnet, row, events, in);
                }
                catch (Throwable e) {
                    LOGGER.error("AnalyzeEvent error: ", e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)fileInputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)fileInputStream);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
        }
        return events;
    }

    private BufferedReader readLineInfoToEvent(File evnet, LogRow row, List<Event> events, InputStreamReader in) throws IOException {
        BufferedReader reader = new BufferedReader(in);
        String line = "";
        int count = 0;
        EventBaiscInfo head = new EventBaiscInfo();
        int type = 0;
        while ((line = reader.readLine()) != null) {
            Event event;
            String info;
            if (line.trim().equalsIgnoreCase("")) continue;
            row.analyzeInterruptedFromStopCommand();
            if (count == 0 && line.matches(HEAD_INFO_REGEX)) {
                Map<String, String> headMap = this.getHeadMap(line);
                head.setName(headMap.get("Name"));
                head.setSn(headMap.get("SN"));
                head.setMode(headMap.get("Mode"));
                head.setVersion(headMap.get("Version"));
                head.setExportTime(headMap.get("Export time"));
                ++count;
                continue;
            }
            if (line.trim().equalsIgnoreCase("Event list") && (line = this.faultListLine(line, reader)) == null) break;
            if (line.matches(NO_SUGGESTION_LINE)) {
                type = this.setTypeOfNoSuggestionLine(line, type);
                ++count;
                continue;
            }
            if (line.matches(SUGGESTION_ON_MORE_LINES)) {
                info = this.getEventOrigininfo(line, reader);
                event = this.getEventForHasnotSequence(info, head);
                event.setFile(evnet);
                event.setType(type);
                events.add(event);
            } else if (line.matches(SUGGESTION_FOR_SEQUENCE)) {
                info = this.getEventOrigininfo(line, reader);
                event = this.getEventForHasSequence(info, head);
                event.setFile(evnet);
                event.setType(type);
                events.add(event);
            }
            ++count;
        }
        return reader;
    }

    private int setTypeOfNoSuggestionLine(String line, int type) {
        if (line.trim().equalsIgnoreCase("Diagnose list")) {
            type = 2;
        }
        if (line.trim().equalsIgnoreCase("Fault list")) {
            type = 0;
        }
        return type;
    }

    private String faultListLine(String line, BufferedReader reader) throws IOException {
        while (!line.trim().equalsIgnoreCase("Diagnose list") && !line.trim().equalsIgnoreCase("Fault list")) {
            line = reader.readLine();
            if (line != null) continue;
            return null;
        }
        return line;
    }

    private String getEventOrigininfo(String line, BufferedReader reader) throws IOException {
        StringBuffer info = new StringBuffer();
        info.append(String.valueOf(line) + "    ");
        String nextline = reader.readLine();
        while (this.readEventTillSuggest(nextline)) {
            info.append("\n" + nextline);
            nextline = reader.readLine();
        }
        return info.toString();
    }

    private boolean readEventTillSuggest(String nextline) {
        return !"None.".equals(nextline) && !NOSUGGESTION.equals(nextline) && nextline != null && !nextline.matches(STARTBYDATA) && !"".equals(nextline);
    }

    private Event getEventForHasnotSequence(String info, EventBaiscInfo head) {
        Event event = new Event();
        if (head != null) {
            event.setBaiscInfo(head);
        }
        String[] infos = info.split("\\s{4}");
        event.setLocalTime(AnalyzeEvent.dealTime(StringUtils.safetyGetStr((String[])infos, (int)0)));
        event.setAlarmID(StringUtils.safetyGetStr((String[])infos, (int)1));
        event.setAlarmLevel(StringUtils.safetyGetStr((String[])infos, (int)2));
        event.setRecoveredLocalTime(AnalyzeEvent.dealTime(StringUtils.safetyGetStr((String[])infos, (int)3)));
        event.setDescription(StringUtils.safetyGetStr((String[])infos, (int)4));
        StringBuffer infoSB = new StringBuffer();
        int i = 5;
        while (i < infos.length) {
            infoSB.append(infos[i]);
            ++i;
        }
        event.setSuggestion(infoSB.toString());
        event.setOrigin(info);
        return event;
    }

    private static String dealTime(String timeStr) {
        Matcher m = p.matcher(timeStr);
        if (m.find()) {
            return m.group();
        }
        return timeStr;
    }

    private Event getEventForHasSequence(String info, EventBaiscInfo head) {
        Event event = new Event();
        if (head != null) {
            event.setBaiscInfo(head);
        }
        String[] infos = info.split("\\s{4}");
        this.makeSequenceAlignRightForSort(infos);
        event.setSequence(infos[0]);
        event.setLocalTime(AnalyzeEvent.dealTime(StringUtils.safetyGetStr((String[])infos, (int)1)));
        event.setAlarmID(StringUtils.safetyGetStr((String[])infos, (int)2));
        event.setEventType(StringUtils.safetyGetStr((String[])infos, (int)3));
        event.setAlarmLevel(StringUtils.safetyGetStr((String[])infos, (int)4));
        event.setState(StringUtils.safetyGetStr((String[])infos, (int)5));
        event.setRecoveredLocalTime(AnalyzeEvent.dealTime(StringUtils.safetyGetStr((String[])infos, (int)6)));
        event.setDescription(StringUtils.safetyGetStr((String[])infos, (int)7));
        StringBuffer infoSB = new StringBuffer();
        int i = 8;
        while (i < infos.length) {
            infoSB.append(infos[i]);
            ++i;
        }
        event.setSuggestion(infoSB.toString());
        event.setOrigin(info);
        return event;
    }

    private void makeSequenceAlignRightForSort(String[] infos) {
        String ablank = " ";
        StringBuilder resultblanksb = new StringBuilder();
        int i = 0;
        while (i < 8 - infos[0].length()) {
            resultblanksb.append(ablank);
            ++i;
        }
        infos[0] = resultblanksb.append(infos[0]).toString();
    }

    private Map<String, String> getHeadMap(String line) {
        HashMap<String, String> headMap = new HashMap<String, String>();
        if (line.isEmpty()) {
            return headMap;
        }
        List<String> infoEntrys = Arrays.asList(line.split("\\s{4}"));
        if (infoEntrys.isEmpty()) {
            return headMap;
        }
        for (String infoEntry : infoEntrys) {
            List<String> infos = Arrays.asList(infoEntry.split(" : "));
            if (infos.isEmpty()) continue;
            headMap.put(infos.get(0), infos.get(1));
        }
        return headMap;
    }

    private Map<Long, List<Event>> getNewAlarm(List<Event> events, LogRow row, long startTime, long endTime) {
        ToolLoggerFactory.getLogger(this.getClass()).info("event size filter before: " + events.size());
        Map<Long, List<Event>> tempMap = new HashMap<Long, List<Event>>();
        AnalyzeEvent.doAnalyzeModule(events);
        for (Event event : events) {
            row.analyzeInterruptedFromStopCommand();
            if (!this.filterEvent(startTime, endTime, event)) continue;
            tempMap = this.getSiftEvents(event, tempMap);
        }
        return tempMap;
    }

    private static void doAnalyzeModule(List<Event> events) {
        for (Event event : events) {
            String[] infos;
            String info;
            if (event.getType() != 2 || !(info = event.getOrigin().toLowerCase(Locale.ENGLISH)).contains("in module") || !(infos = (info = info.substring(info.indexOf("in module") + 9).trim()).split(" "))[0].matches("^\\d+$")) continue;
            event.setpId(infos[0]);
        }
    }

    private boolean filterEvent(long startTime, long endTime, Event event) {
        String level;
        long eventTime = 0L;
        if (!StringUtils.isNULLStr((String)event.getLocalTime())) {
            eventTime = StringUtils.parseDate2Long((String)event.getLocalTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        return (!INFOR_STRING.equals(level = event.getAlarmLevel().toUpperCase(Locale.getDefault())) && !INFORNATION_STRING.equals(level) || 2 == event.getType()) && eventTime <= endTime && eventTime >= startTime;
    }

    private Map<Long, List<Event>> getSiftEvents(Event event, Map<Long, List<Event>> eventsMap) {
        long eventID = Long.parseLong(event.getAlarmID().toUpperCase(Locale.getDefault()).replaceFirst("0X", ""), 16);
        List<Event> eventList = eventsMap.get(eventID);
        if (eventList == null || eventList.isEmpty()) {
            ArrayList<Event> newEvents = new ArrayList<Event>();
            newEvents.add(event);
            eventsMap.put(eventID, newEvents);
            return eventsMap;
        }
        Event lastEvent = eventList.get(eventList.size() - 1);
        long lastEventID = Long.parseLong(lastEvent.getAlarmID().toUpperCase(Locale.getDefault()).replaceFirst("0X", ""), 16);
        if (lastEventID == eventID) {
            boolean hasSame = false;
            for (Event tmpEvent : eventList) {
                if (!event.getLocalTime().equals(tmpEvent.getLocalTime()) || !event.getDescription().equals(tmpEvent.getDescription())) continue;
                hasSame = true;
                break;
            }
            if (!hasSame) {
                eventList.add(event);
                return eventsMap;
            }
        }
        return eventsMap;
    }
}

