/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.FileSearchResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogFileSearchBean;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.ViewLogService;
import com.huawei.ism.tool.loganalyzer.ui.JprogressBar;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;

public class ExportLogFileTread
extends Thread {
    public static final int NUMBER_ZERO = 0;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExportLogFileTread.class);
    private boolean exportResult = true;
    private String filePath;
    private ViewLogService viewLogService;
    private LogFileSearchBean downloadSearchBean;
    private List<FileSearchResult> fileList;
    private JprogressBar bar;

    public ExportLogFileTread(String filePath, List<FileSearchResult> fileList, ViewLogService viewLogService, LogFileSearchBean downloadSearchBean, JprogressBar bar) {
        this.filePath = filePath;
        this.fileList = fileList;
        this.viewLogService = viewLogService;
        this.downloadSearchBean = downloadSearchBean;
        this.bar = bar;
    }

    @Override
    public void run() {
        block7: {
            LOGGER.info("ExportLogFileTread is started.");
            File exportFile = null;
            FileOutputStream fos = null;
            OutputStreamWriter fw = null;
            BufferedWriter fileWriter = null;
            try {
                try {
                    exportFile = new File(this.filePath);
                    File parent = exportFile.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        LOGGER.error("outPutPath create failed!");
                    }
                    if (!exportFile.createNewFile()) {
                        LOGGER.error(String.valueOf(exportFile.getName()) + " create failed!");
                    }
                    fos = new FileOutputStream(exportFile);
                    fw = new OutputStreamWriter((OutputStream)fos, "utf-8");
                    fileWriter = new BufferedWriter(fw);
                    this.viewLogService.exportLogFile(fileWriter, this.fileList, this.downloadSearchBean, this.bar);
                    fileWriter.flush();
                }
                catch (Exception e) {
                    LOGGER.error("Save log file error.", (Throwable)e);
                    this.bar.setProgress(ResourceUtil.getString((String)"info.analyze.advanced.exportFailed"), 0);
                    this.exportResult = false;
                    this.writeOnComplete(fw, fileWriter);
                    this.closeOutputStream(fos);
                    this.viewLogService = null;
                    this.downloadSearchBean = null;
                    this.filePath = null;
                    this.bar = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.writeOnComplete(fw, fileWriter);
                this.closeOutputStream(fos);
                this.viewLogService = null;
                this.downloadSearchBean = null;
                this.filePath = null;
                this.bar = null;
                throw throwable;
            }
            this.writeOnComplete(fw, fileWriter);
            this.closeOutputStream(fos);
            this.viewLogService = null;
            this.downloadSearchBean = null;
            this.filePath = null;
            this.bar = null;
        }
    }

    private void closeOutputStream(FileOutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error("closed FileOutputStream: failed");
            }
        }
    }

    private void writeOnComplete(OutputStreamWriter fw, BufferedWriter fileWriter) {
        try {
            this.closeFileWriter(fw);
            this.closeFileWriter(fileWriter);
        }
        finally {
            if (!this.exportResult) {
                this.deleteFile(this.filePath);
            }
        }
    }

    private void closeFileWriter(Closeable fileWriter) {
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("closed fileWriter: failed", (Throwable)e);
        }
    }

    private void deleteFile(String filePa) {
        File file = new File(filePa);
        if (file.exists() && !file.delete()) {
            LOGGER.error("delete file: failed");
        }
    }
}

