/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.logic.logsearcher.XpathSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.w3c.dom.Node;

public class LogLineParser {
    private static final String IDLOG_REGEX = "(\\[.*\\]){3,}";
    private static final int LOG_ID_RES_LEN = 16;
    private XpathSearcher xpathSearcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogLineParser(File xmlFile) {
        Class<XpathSearcher> clazz = XpathSearcher.class;
        synchronized (XpathSearcher.class) {
            this.xpathSearcher = new XpathSearcher(xmlFile);
            if (!xmlFile.equals(this.xpathSearcher.getLastLogLibFile()) && xmlFile.exists()) {
                this.xpathSearcher.reloadLogIdLib(xmlFile);
            }
            if (!xmlFile.exists()) {
                this.xpathSearcher = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Log parseLog(String line) throws IOException {
        if (this.xpathSearcher == null) {
            return this.commonParse(line);
        }
        Log log = null;
        try {
            log = this.idParse(line);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("idParse error ,log line:" + line, (Throwable)e);
            throw new IOException("The disk is not enough", e);
        }
        return log;
    }

    private Log idParse(String line) throws IOException {
        Log log = null;
        String id = this.getFieldFromLineTrim(line, 2);
        boolean isReplace = false;
        if (line.trim().matches(IDLOG_REGEX) && 16 == id.length()) {
            String date = this.getFieldFromLine(line, 0);
            String jiffes = this.getFieldFromLine(line, 1);
            String args = this.getFieldFromLineTrim(line, 3);
            Node node = this.xpathSearcher.searchNodeByID(id);
            if (node == null) {
                return this.commonParse(line);
            }
            int dotCount = LogLineParser.getDotCount(args, "##");
            Object[] objs = args.split("##", dotCount + 1);
            String content = this.xpathSearcher.getTextContentOfChild(node, "description");
            content = content.replaceAll("%(\\w{1,3})", "%s");
            String ret = "";
            if (content.contains("%s")) {
                try {
                    ret = String.format(content, objs);
                    isReplace = true;
                }
                catch (Exception e) {
                    ret = String.valueOf(content) + Arrays.toString(objs);
                    ToolLoggerFactory.getLogger(this.getClass()).error("parse log error ... log:" + content + "  -->" + line, (Throwable)e);
                }
            } else {
                ret = content;
            }
            String level = this.xpathSearcher.getTextContentOfChild(node, "level");
            String module = this.xpathSearcher.getTextContentOfChild(node, "module");
            String function = this.xpathSearcher.getTextContentOfChild(node, "function");
            StringBuffer sbr = new StringBuffer();
            sbr.append("[");
            sbr.append(function);
            sbr.append("]");
            log = new Log(id, date, level, module, jiffes, sbr.toString(), ret);
            if (isReplace) {
                line = this.replaceDescription(line, ret);
            }
            log.setOriginalStr(line);
        } else {
            log = this.commonParse(line);
        }
        return log;
    }

    private Log commonParse(String line) throws IOException {
        String lineBK = line;
        if (lineBK.startsWith("[")) {
            lineBK = "[" + lineBK;
        }
        if (lineBK.endsWith("]")) {
            lineBK = String.valueOf(lineBK) + "]";
        }
        Log log = null;
        if (!this.isCommonLogLine(line)) {
            log = new Log("", "", "", "", "", "", "");
            log.setOriginalStr(lineBK);
            String logDate = StringUtils.findMatchStr((String)lineBK, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)");
            if (!StringUtils.isNULLStr((String)logDate)) {
                log.setDate(logDate);
            }
            return log;
        }
        String date = "";
        String jiffies = "";
        String id = "";
        String level = "";
        String module = "";
        String other = "";
        String desc = "";
        try {
            line = this.insertSparator(line);
            date = this.getFieldFromLine(line, 0);
            jiffies = this.getFieldFromLine(line, 1);
            id = this.getFieldFromLine(line, 2);
            level = this.getFieldFromLine(line, 3);
            desc = this.getFieldFromLine(line, 4);
            module = this.getFieldFromLine(line, 5);
            other = this.getOtherFields(line, 6, 7);
            other = other.replaceAll(",", " ");
            log = new Log(id, date, level, module, jiffies, other, desc);
            log.setOriginalStr(lineBK);
        }
        catch (Exception e) {
            log = new Log("", "", "", "", "", "", "");
            log.setOriginalStr(lineBK);
            ToolLoggerFactory.getLogger(this.getClass()).error("Parser log error.", (Throwable)e);
        }
        return log;
    }

    private String replaceDescription(String line, String description) {
        StringBuilder ret = new StringBuilder();
        StringBuilder builder = new StringBuilder(line);
        if (line.startsWith("[")) {
            builder.deleteCharAt(builder.indexOf("["));
        }
        if (line.startsWith("]")) {
            builder.deleteCharAt(builder.lastIndexOf("]"));
        }
        String[] fields = builder.toString().split("\\]\\[");
        fields[3] = description;
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ret.append("[");
            ret.append(string);
            ret.append("]");
            ++n2;
        }
        return ret.toString();
    }

    private boolean isCommonLogLine(String line) {
        return line.contains("[") && line.contains("]");
    }

    private String getFieldFromLine(String line, int index) {
        StringBuilder field = new StringBuilder();
        try {
            String[] fields;
            StringBuilder builder = new StringBuilder(line);
            if (line.startsWith("[")) {
                builder.deleteCharAt(builder.indexOf("["));
            }
            if (line.startsWith("]")) {
                builder.deleteCharAt(builder.lastIndexOf("]"));
            }
            if ((fields = builder.toString().split("\\]\\[")).length <= index) {
                return field.toString();
            }
            String tmp = fields[index];
            if (tmp.length() == 0) {
                return field.toString();
            }
            if (!line.startsWith("[")) {
                field.append("[");
            }
            field.append(tmp);
            if (!line.startsWith("]")) {
                field.append("]");
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Parser log error.", (Throwable)e);
        }
        return field.toString();
    }

    private String getFieldFromLineTrim(String line, int index) {
        String str = this.getFieldFromLine(line, index);
        str = str.replace("[", "");
        str = str.replace("]", "");
        return str.trim();
    }

    private String getOtherFields(String line, int ... indexes) {
        StringBuilder result = new StringBuilder();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String field = this.getFieldFromLine(line, index);
            if (field.length() != 0) {
                if (!field.startsWith("[")) {
                    result.append("[");
                }
                if (!field.endsWith("]")) {
                    result.append("]");
                }
                result.append(field);
            }
            ++n2;
        }
        return result.toString();
    }

    private String insertSparator(String line) {
        StringBuffer sb = new StringBuffer();
        int len = line.length();
        int i = 0;
        while (i < len - 1) {
            char ch = line.charAt(i);
            char nextCh = line.charAt(i + 1);
            sb.append(ch);
            if (ch == ']' && nextCh != '[') {
                sb.append('[');
            } else if (nextCh == '[' && ch != ']') {
                sb.append(']');
            }
            ++i;
        }
        sb.append(line.charAt(i));
        sb.append(']');
        return sb.toString();
    }

    private static int getDotCount(String line, String ch) {
        int index = 0;
        int count = 0;
        index = line.indexOf(ch, index);
        while (-1 != index) {
            ++index;
            ++count;
            index = line.indexOf(ch, index);
        }
        return count;
    }
}

