/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.PythonRule;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.entity.log.Log;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class PyScriptExecute {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PyScriptExecute.class);
    private PythonRule rule;
    private File logDir;
    private LogRow row;

    public PyScriptExecute(PythonRule rule, File logDir, LogRow row) {
        this.rule = rule;
        this.logDir = logDir;
        this.row = row;
    }

    private Map<String, Object> initEnv() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        env.put("lang", language);
        env.put("logFile", this.logDir.getAbsolutePath());
        env.put("logger", LOGGER);
        env.put("startTime", SearchConstant.getInstant().getStartTime());
        env.put("endTime", SearchConstant.getInstant().getEndTime());
        return env;
    }

    public Map<SingleLogSearchRule, List<Log>> search() {
        this.row.analyzeInterruptedFromStopCommand();
        Map<String, Object> envMap = this.initEnv();
        File scriptFile = this.rule.getPythonFile();
        String method = this.rule.getExeMethod();
        if (!scriptFile.exists()) {
            return null;
        }
        JythonExecuter jythonExecuter = new JythonExecuter(scriptFile.getParentFile());
        try {
            jythonExecuter.compileScript(scriptFile);
            List ret = jythonExecuter.invokeFunction(method, envMap);
            return this.getReslut(ret);
        }
        catch (SignException e) {
            LOGGER.error("Search python reslut failed.", (Throwable)e);
            return null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Search python reslut failed.", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Search python reslut failed.", (Throwable)e);
            return null;
        }
    }

    private Map<SingleLogSearchRule, List<Log>> getReslut(List<Object> ret) {
        ArrayList<Log> logs = new ArrayList<Log>();
        String executeRet = ret.get(0).toString();
        HashMap<SingleLogSearchRule, List<Log>> ruleLogResult = new HashMap<SingleLogSearchRule, List<Log>>();
        if (!Boolean.valueOf(executeRet).booleanValue()) {
            return ruleLogResult;
        }
        Map retMap = (Map)ret.get(1);
        Iterator iterable = retMap.entrySet().iterator();
        SingleLogSearchRule singleLogSearchRule = new SingleLogSearchRule();
        while (iterable.hasNext()) {
            this.row.analyzeInterruptedFromStopCommand();
            Map.Entry entry = iterable.next();
            String file = (String)entry.getKey();
            ArrayList<String> originalStrList = new ArrayList<String>();
            String value = (String)entry.getValue();
            String[] originalLogs = value.split("\\n");
            originalStrList.addAll(Arrays.asList(originalLogs));
            logs.addAll(this.getLogs(file, originalStrList));
        }
        singleLogSearchRule.setLogRecordReturn(SingleLogSearchRule.LogRecordReturn.ALL);
        ruleLogResult.put(singleLogSearchRule, logs);
        return ruleLogResult;
    }

    private List<Log> getLogs(String file, List<String> originalStrList) {
        ArrayList<Log> logs = new ArrayList<Log>();
        File logFile = new File(file);
        if (!logFile.exists()) {
            return logs;
        }
        for (String originalStr : originalStrList) {
            this.row.analyzeInterruptedFromStopCommand();
            Log log = new Log("", "", "", "", "", "", "");
            log.setLogPath(FileUtil.getFilePath(logFile));
            log.setOriginalStr(originalStr);
            logs.add(log);
            if (logs.size() <= 10000) continue;
            ToolLoggerFactory.getLogger(this.getClass()).error(String.valueOf(logFile.getName()) + " more then 10000 log");
            break;
        }
        return logs;
    }
}

