/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ConfigInfoEntry;
import com.huawei.ism.tool.loganalyzer.logic.configloader.ConfigInfoReader;
import com.huawei.ism.tool.loganalyzer.logic.configsearcher.ClicmdFileSearcher;
import com.huawei.ism.tool.loganalyzer.logic.configsearcher.ConfigFileSearcher;
import com.huawei.ism.tool.loganalyzer.logic.configsearcher.FileSearcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SoftHardwareConfiginfoSearch {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ConfigInfoReader.class);
    private static final List<FileSearcher> FILESEARCHERLIST = new ArrayList<FileSearcher>();

    static {
        try {
            FILESEARCHERLIST.add(new ClicmdFileSearcher());
            FILESEARCHERLIST.add(new ConfigFileSearcher());
        }
        catch (Throwable e) {
            LOGGER.error("Init CollectionThread failed: ", e);
        }
    }

    public ConfigInfoEntry search(List<File> deCompressFiles) {
        ArrayList<ConfigInfoEntry> configInfoEntryList = new ArrayList<ConfigInfoEntry>();
        try {
            for (FileSearcher s : FILESEARCHERLIST) {
                configInfoEntryList.add(s.doSearch(deCompressFiles));
            }
        }
        catch (Throwable e) {
            LOGGER.error("SoftHardware Configinfo Search failed:" + e.getMessage() + "\uff1a", e);
        }
        return this.getConfigInfoEntry(configInfoEntryList);
    }

    public ConfigInfoEntry getConfigInfoEntry(List<ConfigInfoEntry> configInfoEntryList) {
        ConfigInfoEntry configInfoEntry = new ConfigInfoEntry();
        for (ConfigInfoEntry c : configInfoEntryList) {
            if (c == null) continue;
            configInfoEntry.setBasicInfo(StringUtils.isNULLStr((String)configInfoEntry.getBasicInfo()) ? c.getBasicInfo() : configInfoEntry.getBasicInfo());
            configInfoEntry.setControllerEnc(StringUtils.isNULLStr((String)configInfoEntry.getControllerEnc()) ? c.getControllerEnc() : configInfoEntry.getControllerEnc());
            configInfoEntry.setDiskDomain(StringUtils.isNULLStr((String)configInfoEntry.getDiskDomain()) ? c.getDiskDomain() : configInfoEntry.getDiskDomain());
            configInfoEntry.setDiskEnc(StringUtils.isNULLStr((String)configInfoEntry.getDiskEnc()) ? c.getDiskEnc() : configInfoEntry.getDiskEnc());
            configInfoEntry.setHost(StringUtils.isNULLStr((String)configInfoEntry.getHost()) ? c.getHost() : configInfoEntry.getHost());
            configInfoEntry.setLicense(StringUtils.isNULLStr((String)configInfoEntry.getLicense()) ? c.getLicense() : configInfoEntry.getLicense());
            configInfoEntry.setLun(StringUtils.isNULLStr((String)configInfoEntry.getLun()) ? c.getLun() : configInfoEntry.getLun());
            configInfoEntry.setMappingView(StringUtils.isNULLStr((String)configInfoEntry.getMappingView()) ? c.getMappingView() : configInfoEntry.getMappingView());
            configInfoEntry.setPort(StringUtils.isNULLStr((String)configInfoEntry.getPort()) ? c.getPort() : configInfoEntry.getPort());
            configInfoEntry.setStoragePool(StringUtils.isNULLStr((String)configInfoEntry.getStoragePool()) ? c.getStoragePool() : configInfoEntry.getStoragePool());
        }
        return configInfoEntry;
    }
}

