/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.AdvancedSearchResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.FileSearchResult;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogFileSearchBean;
import com.huawei.ism.tool.loganalyzer.entity.analyze.SearchResult;
import com.huawei.ism.tool.loganalyzer.ui.JprogressBar;
import com.huawei.ism.tool.loganalyzer.util.ComparatorUtils;
import com.huawei.ism.tool.loganalyzer.util.FileListFileFilterUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextArea;
import org.slf4j.Logger;

public class ViewLogService {
    public static final int APPEND_LINE_NUM = 500;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ViewLogService.class);

    public void exportLogFile(BufferedWriter fileWriter, List<FileSearchResult> fileList, LogFileSearchBean searchBean, JprogressBar bar) throws IOException {
        int index = 0;
        int i = 0;
        while (i < fileList.size()) {
            List<SearchResult> resultList = this.getSearchContentByPage(fileList.get(i).getFile(), searchBean);
            for (SearchResult sr : resultList) {
                fileWriter.write(sr.getOriginal() + "\n");
                if (++index % 5000 != 0) continue;
                fileWriter.flush();
            }
            StringBuilder tip = new StringBuilder();
            tip.append(ResourceUtil.getStringWithParams((String)"info.analyze.advanced.exported", (Object[])new Object[]{index}));
            bar.setProgress(tip.toString(), (i + 1) * 100 / fileList.size());
            ++i;
        }
        bar.setProgress(ResourceUtil.getString((String)"info.analyze.advanced.exportSucceeded"), 100);
    }

    public List<File> getSubFiles(File pkgFolder, String ctrlName, String fileNameReg) {
        File ctrlFolder = this.getCtrlFolder(pkgFolder, ctrlName);
        ArrayList<File> subFiles = new ArrayList<File>();
        if (ctrlFolder != null) {
            this.getAllFilesByFileName(ctrlFolder, subFiles, fileNameReg);
        }
        Collections.sort(subFiles, ComparatorUtils.LOADLOGTIME_FILE_TIME_SORT);
        return subFiles;
    }

    public AdvancedSearchResult getSearchResult(List<File> subFiles, LogFileSearchBean searchBean) {
        AdvancedSearchResult advancedSearchResult = new AdvancedSearchResult();
        int fileResultCount = 0;
        for (File file : subFiles) {
            fileResultCount = this.countContainKeyLine(file, searchBean);
            if (fileResultCount <= 0) continue;
            advancedSearchResult.addTotalCount(fileResultCount);
            advancedSearchResult.addFile(new FileSearchResult(file, fileResultCount));
        }
        Collections.sort(advancedSearchResult.getFileList(), ComparatorUtils.SEARCH_FILE_TIME_SORT);
        return advancedSearchResult;
    }

    public int countContainKeyLine(File file, LogFileSearchBean searchBean) {
        int count;
        block6: {
            count = 0;
            InputStreamReader reader = null;
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    reader = new InputStreamReader((InputStream)fis, "UTF-8");
                    br = new BufferedReader(reader);
                    String lineStr = "";
                    while ((lineStr = br.readLine()) != null) {
                        if (!this.isValidOk(searchBean, lineStr)) continue;
                        ++count;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("countContainKeyLine occor an error: ", (Throwable)e);
                    this.close(br, reader, fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(br, reader, fis);
                throw throwable;
            }
            this.close(br, reader, fis);
        }
        return count;
    }

    private boolean isValidOk(LogFileSearchBean searchBean, String lineStr) {
        if (lineStr.trim().length() == 0) {
            return false;
        }
        if (searchBean.getContainKeywords() == null && searchBean.getNotContainKeywords() == null) {
            return false;
        }
        if (searchBean.getContainKeywords() != null && !searchBean.validContainsKeywords(lineStr)) {
            return false;
        }
        if (searchBean.getNotContainKeywords() != null && searchBean.validNotContainsKeywords(lineStr)) {
            return false;
        }
        return searchBean.validDateRange(lineStr);
    }

    public File getCtrlFolder(File pkgFolder, String ctrlName) {
        ArrayList<File> ctrlFolderList = new ArrayList<File>();
        this.getCtrlFolder(pkgFolder, ctrlName, ctrlFolderList);
        return ctrlFolderList.size() == 1 ? (File)ctrlFolderList.get(0) : null;
    }

    private void getAllFilesByFileName(File tempFile, List<File> files, String fileNameReg) {
        File[] subFiles = tempFile.listFiles();
        if (subFiles != null) {
            File[] fileArray = subFiles;
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().matches(fileNameReg)) {
                    files.add(f);
                } else if (f.isDirectory()) {
                    this.getAllFilesByFileName(f, files, fileNameReg);
                }
                ++n2;
            }
        }
    }

    public void getCtrlFolder(File tempFile, String ctrlName, List<File> ctrlFolderList) {
        File[] subFiles;
        File[] fileArray = subFiles = FileListFileFilterUtils.fileList(tempFile, null);
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                if (f.getName().equals(ctrlName)) {
                    ctrlFolderList.add(f);
                    break;
                }
                this.getCtrlFolder(f, ctrlName, ctrlFolderList);
            }
            ++n2;
        }
    }

    public List<SearchResult> getSearchContentByPage(File file, LogFileSearchBean searchBean) {
        ArrayList<SearchResult> searchResultList;
        block6: {
            searchResultList = new ArrayList<SearchResult>();
            InputStreamReader reader = null;
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    reader = new InputStreamReader((InputStream)fis, "UTF-8");
                    br = new BufferedReader(reader);
                    String lineStr = "";
                    SearchResult searchResult = null;
                    int logLine = 0;
                    while ((lineStr = br.readLine()) != null) {
                        ++logLine;
                        if (!this.isValidOk(searchBean, lineStr)) continue;
                        searchResult = new SearchResult(logLine, file, lineStr, searchBean.getContainKeywords());
                        searchResultList.add(searchResult);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("getSearchContentByPage error", (Throwable)e);
                    this.close(br, reader, fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(br, reader, fis);
                throw throwable;
            }
            this.close(br, reader, fis);
        }
        return searchResultList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SearchResult> pageQuery(List<FileSearchResult> fileList, LogFileSearchBean searchBean) {
        searchResultList = new ArrayList<SearchResult>();
        pageSize = searchBean.getPageSize();
        startLineNum = (searchBean.getCurPage() - 1) * pageSize;
        recordCount = 0;
        recordNum = 0;
        i = 0;
        while (true) {
            block12: {
                if (i >= fileList.size()) {
                    if (searchResultList.isEmpty()) {
                        this.addMessage(searchResultList, searchBean);
                    }
                    return searchResultList;
                }
                fsr = fileList.get(i);
                if (recordCount + fsr.getFileResultCount() < startLineNum) {
                    recordCount += fsr.getFileResultCount();
                } else {
                    file = fileList.get(i).getFile();
                    reader = null;
                    fis = null;
                    br = null;
                    try {
                        fis = new FileInputStream(file);
                        reader = new InputStreamReader((InputStream)fis, "UTF-8");
                        br = new BufferedReader(reader);
                        lineStr = "";
                        searchResult = null;
                        logLine = 0;
                    }
                    catch (Exception e) {
                        ViewLogService.LOGGER.error("getSearchContentByPage error", (Throwable)e);
                        this.close(br, reader, fis);
                        break block12;
                    }
                    catch (Throwable var17_19) {
                        this.close(br, reader, fis);
                        throw var17_19;
                    }
                    {
                        ** while ((lineStr = br.readLine()) != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++logLine;
                        if (!this.isValidOk(searchBean, lineStr)) continue;
                        if (startLineNum < ++recordCount) {
                            ++recordNum;
                            searchResult = new SearchResult(logLine, file, lineStr, searchBean.getContainKeywords());
                            searchResultList.add(searchResult);
                        }
                        if (recordNum != pageSize) continue;
                        var18_18 = searchResultList;
                        this.close(br, reader, fis);
                        return var18_18;
                    }
lbl47:
                    // 1 sources

                    this.close(br, reader, fis);
                }
            }
            ++i;
        }
    }

    private void addMessage(List<SearchResult> searchResultList, LogFileSearchBean searchBean) {
        SearchResult searchResult = new SearchResult();
        if (searchBean.getContainKeywords() == null && searchBean.getNotContainKeywords() == null) {
            searchResult.setMessage(ResourceUtil.getString((String)"info.analyze.advanced.noKeywords"));
        } else {
            searchResult.setMessage(ResourceUtil.getString((String)"info.analyze.advanced.noRecords"));
        }
        searchResultList.add(searchResult);
    }

    public List<String> getOriginalfileContent(File file, JTextArea fileContentArea) {
        ArrayList<String> fileContentList;
        block6: {
            fileContentList = new ArrayList<String>();
            InputStreamReader reader = null;
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    reader = new InputStreamReader((InputStream)fis, "GBK");
                    br = new BufferedReader(reader);
                    String line = "";
                    int index = 0;
                    StringBuilder fileContent = new StringBuilder();
                    fileContentArea.setText(line);
                    while ((line = br.readLine()) != null) {
                        fileContent.append(line).append("\n");
                        if (++index % 500 != 0) continue;
                        fileContentArea.append(fileContent.toString());
                        fileContent.setLength(0);
                    }
                    fileContentArea.append(fileContent.toString());
                }
                catch (Exception e) {
                    LOGGER.error("getfileContent error", (Throwable)e);
                    this.close(br, reader, fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(br, reader, fis);
                throw throwable;
            }
            this.close(br, reader, fis);
        }
        return fileContentList;
    }

    private void close(Closeable br, InputStreamReader reader, FileInputStream fis) {
        StreamUtils.closeResource(null, (Closeable)br);
        StreamUtils.closeResource(null, (Closeable)reader);
        StreamUtils.closeResource(null, (Closeable)fis);
    }

    public void destroy() {
    }
}

