/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.logsearcher;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XpathSearcher {
    private static final int MAX_NODE_COUNT = 50000;
    private Map<String, Node> idNodeMap = new HashMap<String, Node>(50000);
    private File lastLogLibFile;

    public XpathSearcher(File xmlFile) {
        if (xmlFile.exists()) {
            this.loadLogIdLib(xmlFile);
        }
    }

    public void reloadLogIdLib(File xmlFile) {
        if (xmlFile.exists()) {
            this.idNodeMap.clear();
            this.lastLogLibFile = null;
            this.loadLogIdLib(xmlFile);
        }
    }

    private void loadLogIdLib(File xmlFile) {
        block6: {
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(xmlFile);
                    Document doc = XmlUtils.parseDocument((InputStream)input);
                    Collection items = XmlUtils.getChildren((Element)doc.getDocumentElement());
                    for (Element item : items) {
                        String id = XmlUtils.getTextContentOfChild((Element)item, (String)"ID");
                        if (id == null) continue;
                        id = id.trim();
                        id = id.toUpperCase(Locale.ENGLISH);
                        this.idNodeMap.put(id, item);
                    }
                    this.lastLogLibFile = xmlFile;
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("read file error:" + xmlFile, (Throwable)e);
                    StreamUtils.closeStream(null, (InputStream)input);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, input);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)input);
        }
    }

    public File getLastLogLibFile() {
        return this.lastLogLibFile;
    }

    public Node searchNodeByID(String id) {
        id = id.toUpperCase(Locale.ENGLISH);
        return this.idNodeMap.get(id);
    }

    public String getTextContentOfChild(Node node, String childTagName) {
        return XmlUtils.getTextContentOfChild((Element)((Element)node), (String)childTagName);
    }
}

