/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.pkgdecompress;

import com.huawei.ism.tool.base.utils.SerializableUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class DecPkgManager {
    private static final String DISK_STORE_FILENAME = "InfoAnalyzerPkgMappingStore";
    private static Map<String, File> pkgMapingCache = new HashMap<String, File>();

    static {
        Object mp = SerializableUtils.readObject((String)DISK_STORE_FILENAME, (String)ApplicationContext.getInstance().getWorkPath());
        pkgMapingCache = mp instanceof Map ? (Map<Object, Object>)mp : new HashMap<String, File>();
    }

    private DecPkgManager() {
    }

    public static synchronized boolean isContainsPkg(String pkgDir) {
        HashMap<String, File> tempMapping = new HashMap<String, File>();
        for (Map.Entry<String, File> pkgCacheEntry : pkgMapingCache.entrySet()) {
            if (!pkgCacheEntry.getValue().exists()) continue;
            tempMapping.put(pkgCacheEntry.getKey(), pkgCacheEntry.getValue());
        }
        pkgMapingCache = tempMapping;
        return pkgMapingCache.containsKey(pkgDir) && pkgMapingCache.get(pkgDir).exists();
    }

    public static synchronized File getPckDir(String pkgDir) {
        return pkgMapingCache.get(pkgDir);
    }

    public static synchronized File addPckMapping(String pkgName, File logFile) {
        pkgMapingCache.put(pkgName, logFile);
        DecPkgManager.flushMap2Disk();
        return logFile;
    }

    private static void flushMap2Disk() {
        SerializableUtils.writeObject(pkgMapingCache, (String)DISK_STORE_FILENAME, (String)ApplicationContext.getInstance().getWorkPath());
    }
}

