/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.pkgdecompress;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

public class ExecuteCmdProcess {
    public static final String ENTER = System.getProperty("line.separator");
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExecuteCmdProcess.class);
    private Process process = null;
    private StringBuffer buff = new StringBuffer();

    public ExecuteCmdProcess(Process process) {
        this.process = process;
    }

    public String call() {
        block5: {
            try {
                try {
                    this.refleshOutput(this.process.getInputStream());
                    this.buff.append(ENTER);
                    this.buff.append("stdout over---------------------------------------------------");
                    this.buff.append(ENTER);
                    this.refleshOutput(this.process.getErrorStream());
                    this.buff.append(ENTER);
                    this.buff.append("stderr over---------------------------------------------------");
                    this.buff.append(ENTER);
                }
                catch (Exception e) {
                    LOGGER.error("Read ins error :", (Throwable)e);
                    this.exitProcess();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.exitProcess();
                throw throwable;
            }
            this.exitProcess();
        }
        return this.buff.toString();
    }

    private void exitProcess() {
        while (true) {
            try {
                Thread.sleep(5L);
                this.logException();
                this.process.exitValue();
                this.process.destroy();
            }
            catch (RuntimeException e) {
                this.logException();
                continue;
            }
            catch (Exception ee) {
                LOGGER.debug("this process thread has been interrupted", (Throwable)ee);
            }
            break;
        }
    }

    private void logException() {
        try {
            this.refleshOutput(this.process.getInputStream());
            this.refleshOutput(this.process.getErrorStream());
        }
        catch (Exception ex) {
            LOGGER.error("the second output error", (Throwable)ex);
        }
    }

    private void refleshOutput(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return;
        }
        while ((len = is.available()) > 0) {
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            this.buff.append(new String(bs, 0, bSize, "UTF-8"));
        }
    }
}

