/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.logic.pkgdecompress;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class SearchBomCodeByFile {
    private static final String SERIAL_NUM = "Serial Number";
    private static final String ID_NUM = "ID";
    private static final String BARCODE = "Barcode";
    private static final String CONFIG = "config.txt|config|osm_sysconfig.txt";
    private static final String DISKMART_IINFO = "basicinfo.txt|basic_info|basic_info.txt";
    private static final String CLICMD = "clicmd.txt";
    private static final String BDM_INFO = "bdm_info";
    private static final String DIAGNOSE = "diagnose>";
    private static final String BAR_CODE = "Bar Code";
    private static final String BARCODES = "BarCode";
    private static final String DISK_FRAME = "Disk Frame and Slot ID";
    private static final String SHOW_DISK = "show disk general disk_id";
    private static final String DISK_LOCATION = "Disk Location";
    private static final int START_INDEX = 2;
    private static final int END_INDEX = 10;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SearchBomCodeByFile.class);
    private static SearchBomCodeByFile instance = null;

    public static synchronized SearchBomCodeByFile getInstance() {
        if (instance == null) {
            instance = new SearchBomCodeByFile();
        }
        return instance;
    }

    public void searchBomCode(List<File> searchFileList, String logFile) {
        HashMap<String, String> bomCodeMap = new HashMap<String, String>();
        for (File file : searchFileList) {
            if (BDM_INFO.contains(file.getName().toLowerCase(Locale.ENGLISH))) {
                this.readBdmFileLine(file, bomCodeMap);
                continue;
            }
            if (CONFIG.contains(file.getName().toLowerCase(Locale.ENGLISH))) {
                this.getBomByConfigFile(file, bomCodeMap);
                continue;
            }
            if (DISKMART_IINFO.contains(file.getName().toLowerCase(Locale.ENGLISH))) {
                this.readBasicOrCliInfo(file, bomCodeMap);
                this.readOtherBasicInfo(file, bomCodeMap);
                continue;
            }
            if (!CLICMD.contains(file.getName().toLowerCase(Locale.ENGLISH))) continue;
            this.readBasicOrCliInfo(file, bomCodeMap);
        }
        LoganalyzerContext.getInstance().getBomCodeConcurrentMap().put(logFile, bomCodeMap);
    }

    public void setAllBomCode(List<File> searchFileList, String logFile) {
        try {
            this.searchBomCode(searchFileList, logFile);
        }
        catch (Exception e) {
            LOGGER.error("search bom code by file is error ", (Throwable)e);
        }
    }

    private void getBomByConfigFile(File configFile, Map<String, String> bomCodeMap) {
        if (configFile.exists()) {
            this.readConfigFileLine(configFile, bomCodeMap);
            this.readeOtherKey(configFile, bomCodeMap);
        }
    }

    private void readBdmFileLine(File bdmFile, Map<String, String> bomCodeMap) {
        block11: {
            FileInputStream usrmemoveruseInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            String line = null;
            try {
                try {
                    usrmemoveruseInputStream = new FileInputStream(bdmFile);
                    in = new InputStreamReader((InputStream)usrmemoveruseInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    int startSerialIndex = -1;
                    int bomCodeIndex = -1;
                    int idIndex = -1;
                    while ((line = reader.readLine()) != null) {
                        if (this.containIgnoreCase(line, SERIAL_NUM) && this.containIgnoreCase(line, BARCODE)) {
                            startSerialIndex = line.indexOf(SERIAL_NUM);
                            bomCodeIndex = line.indexOf(BARCODE);
                            continue;
                        }
                        if (this.containIgnoreCase(line, ID_NUM) && !this.containIgnoreCase(line, SERIAL_NUM) && this.containIgnoreCase(line, BARCODE)) {
                            idIndex = line.indexOf(ID_NUM);
                            bomCodeIndex = line.indexOf(BARCODE);
                            continue;
                        }
                        StringBuffer slotId = new StringBuffer();
                        StringBuffer serialCode = new StringBuffer();
                        StringBuffer bom = new StringBuffer();
                        if (startSerialIndex != -1 && bomCodeIndex != -1) {
                            if (line.contains(DIAGNOSE)) {
                                startSerialIndex = -1;
                                bomCodeIndex = -1;
                                continue;
                            }
                            this.addSeridAndBom(line, startSerialIndex, bomCodeIndex, serialCode, bom);
                            this.setBom(serialCode.toString(), bom.toString(), bomCodeMap);
                        }
                        if (idIndex == -1 || bomCodeIndex == -1) continue;
                        if (line.contains("#")) {
                            idIndex = -1;
                            bomCodeIndex = -1;
                            continue;
                        }
                        this.addIdAndBom(line, idIndex, bomCodeIndex, slotId, bom);
                        this.setBom(slotId.toString(), bom.toString(), bomCodeMap);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("load bdm info error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                    LOGGER.info("bdm_info file BomCode Map:" + bomCodeMap);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                LOGGER.info("bdm_info file BomCode Map:" + bomCodeMap);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
            LOGGER.info("bdm_info file BomCode Map:" + bomCodeMap);
        }
    }

    private void setBom(String serialCode, String bom, Map<String, String> bomCodeMap) {
        if (!serialCode.isEmpty() && !bom.isEmpty() && bom.length() > 9) {
            String bomCode = bom.substring(2, 10);
            bomCodeMap.put(serialCode, bomCode);
        }
    }

    private void addSeridAndBom(String line, int startSerialIndex, int bomCodeIndex, StringBuffer serialCode, StringBuffer bom) {
        this.getBomAndSerialNum(line, startSerialIndex, serialCode);
        this.getBomAndSerialNum(line, bomCodeIndex, bom);
    }

    private void getBomAndSerialNum(String line, int index, StringBuffer infoBuffer) {
        int num = index;
        while (num < line.length()) {
            if (this.isSpecialChar(line, num)) break;
            infoBuffer.append(line.charAt(num));
            ++num;
        }
    }

    private boolean isSpecialChar(String line, int num) {
        return !(line.charAt(num) != ' ' && line.charAt(num) != '-' || line.charAt(num) != ' ' && line.charAt(num + 1) != '-');
    }

    private void readConfigFileLine(File config, Map<String, String> bomCodeMap) {
        block11: {
            FileInputStream usrmemoveruseInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            String line = null;
            try {
                try {
                    usrmemoveruseInputStream = new FileInputStream(config);
                    in = new InputStreamReader((InputStream)usrmemoveruseInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    int startSerialIndex = -1;
                    int bomCodeIndex = -1;
                    int idIndex = -1;
                    while ((line = reader.readLine()) != null) {
                        if (this.containIgnoreCase(line, SERIAL_NUM) && this.containIgnoreCase(line, BAR_CODE)) {
                            startSerialIndex = line.indexOf(SERIAL_NUM);
                            bomCodeIndex = line.indexOf(BAR_CODE);
                            continue;
                        }
                        if (this.containIgnoreCase(line, ID_NUM) && this.containIgnoreCase(line, BAR_CODE)) {
                            idIndex = line.indexOf(ID_NUM);
                            bomCodeIndex = line.indexOf(BAR_CODE);
                            continue;
                        }
                        StringBuffer slotId = new StringBuffer();
                        StringBuffer serialCode = new StringBuffer();
                        StringBuffer bom = new StringBuffer();
                        if (startSerialIndex != -1 && bomCodeIndex != -1) {
                            if (line.contains("#")) {
                                startSerialIndex = -1;
                                bomCodeIndex = -1;
                                continue;
                            }
                            this.addSeridAndBom(line, startSerialIndex, bomCodeIndex, serialCode, bom);
                            this.setBom(serialCode.toString(), bom.toString(), bomCodeMap);
                        }
                        if (idIndex == -1 || bomCodeIndex == -1) continue;
                        if (line.contains("#")) {
                            idIndex = -1;
                            bomCodeIndex = -1;
                            continue;
                        }
                        this.addIdAndBom(line, idIndex, bomCodeIndex, slotId, bom);
                        this.setBom(slotId.toString(), bom.toString(), bomCodeMap);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("config file load config info error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                    LOGGER.info("config file Bomcode Map:" + bomCodeMap);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                LOGGER.info("config file Bomcode Map:" + bomCodeMap);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
            LOGGER.info("config file Bomcode Map:" + bomCodeMap);
        }
    }

    private void readeOtherKey(File config, Map<String, String> bomCodeMap) {
        block8: {
            FileInputStream usrmemoveruseInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            String line = null;
            try {
                try {
                    usrmemoveruseInputStream = new FileInputStream(config);
                    in = new InputStreamReader((InputStream)usrmemoveruseInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    String soltId = "";
                    ArrayList<String> soltList = null;
                    while ((line = reader.readLine()) != null) {
                        String barCode = "";
                        if (this.containIgnoreCase(line, DISK_FRAME)) {
                            soltList = new ArrayList<String>();
                            soltId = line.split(":")[1].trim();
                            this.isExistSoltId(soltList, soltId, bomCodeMap);
                        }
                        if (this.containIgnoreCase(line, BARCODES)) {
                            barCode = line.split("=")[1].trim();
                        }
                        if (soltList == null || !soltList.isEmpty()) continue;
                        this.setBom(soltId, barCode, bomCodeMap);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("config file load other key error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                    LOGGER.info("config file Bomcode Map:" + bomCodeMap);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                LOGGER.info("config file Bomcode Map:" + bomCodeMap);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
            LOGGER.info("config file Bomcode Map:" + bomCodeMap);
        }
    }

    private void isExistSoltId(List<String> soltList, String soltId, Map<String, String> bomCodeMap) {
        for (String bomString : bomCodeMap.keySet()) {
            if (!bomString.equals(soltId)) continue;
            soltList.add(soltId);
            break;
        }
    }

    private void addIdAndBom(String line, int idIndex, int bomCodeIndex, StringBuffer slotId, StringBuffer bom) {
        this.setIdAndBom(line, idIndex, slotId);
        this.setIdAndBom(line, bomCodeIndex, bom);
    }

    private void setIdAndBom(String line, int index, StringBuffer infoBuffer) {
        int num = index;
        while (num < line.length()) {
            if (line.charAt(num) == ' ') break;
            infoBuffer.append(line.charAt(num));
            ++num;
        }
    }

    private void readBasicOrCliInfo(File infoFile, Map<String, String> bomCodeMap) {
        block5: {
            FileInputStream usrmemoveruseInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            try {
                try {
                    usrmemoveruseInputStream = new FileInputStream(infoFile);
                    in = new InputStreamReader((InputStream)usrmemoveruseInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    this.analyzeBasicInfoAndClicmdFile(bomCodeMap, reader);
                }
                catch (Exception e) {
                    LOGGER.error("load other key error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                    LOGGER.info("basicinfo and clicmd Bomcode Map:" + bomCodeMap);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                LOGGER.info("basicinfo and clicmd Bomcode Map:" + bomCodeMap);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
            LOGGER.info("basicinfo and clicmd Bomcode Map:" + bomCodeMap);
        }
    }

    private void analyzeBasicInfoAndClicmdFile(Map<String, String> bomCodeMap, BufferedReader reader) throws IOException {
        String line;
        String soltId = "";
        ArrayList<String> soltList = null;
        while ((line = reader.readLine()) != null) {
            String[] bomstrs;
            String barCode = "";
            if (this.containIgnoreCase(line, SHOW_DISK)) {
                soltList = new ArrayList<String>();
                soltId = line.split("=")[1].trim();
                this.isExistSoltId(soltList, soltId, bomCodeMap);
            }
            if (this.containIgnoreCase(line, BAR_CODE) && (bomstrs = line.split(":")).length > 1) {
                barCode = bomstrs[1].trim();
            }
            if (soltList == null || !soltList.isEmpty()) continue;
            this.setBom(soltId, barCode, bomCodeMap);
        }
    }

    private void readOtherBasicInfo(File basicInfo, Map<String, String> bomCodeMap) {
        block5: {
            FileInputStream usrmemoveruseInputStream = null;
            InputStreamReader in = null;
            BufferedReader reader = null;
            try {
                try {
                    usrmemoveruseInputStream = new FileInputStream(basicInfo);
                    in = new InputStreamReader((InputStream)usrmemoveruseInputStream, "UTF-8");
                    reader = new BufferedReader(in);
                    this.getKeyPosition(bomCodeMap, reader);
                }
                catch (Exception e) {
                    LOGGER.error(" load  basicinfo info error: ", (Throwable)e);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                    LOGGER.info("disksmartinfo file Bomcode Map:" + bomCodeMap);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
                LOGGER.info("disksmartinfo file Bomcode Map:" + bomCodeMap);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)usrmemoveruseInputStream);
            LOGGER.info("disksmartinfo file Bomcode Map:" + bomCodeMap);
        }
    }

    private void getKeyPosition(Map<String, String> bomCodeMap, BufferedReader reader) throws IOException {
        String line;
        int startSerialIndex = -1;
        int bomCodeIndex = -1;
        int idIndex = -1;
        while ((line = reader.readLine()) != null) {
            if (this.containIgnoreCase(line, SERIAL_NUM) && this.containIgnoreCase(line, BARCODES)) {
                startSerialIndex = line.indexOf(SERIAL_NUM);
                bomCodeIndex = line.indexOf(BARCODES);
                continue;
            }
            if (this.containIgnoreCase(line, DISK_LOCATION) && this.containIgnoreCase(line, BARCODES)) {
                idIndex = line.indexOf(DISK_LOCATION);
                bomCodeIndex = line.indexOf(BARCODES);
                continue;
            }
            Map<String, Integer> index = this.getBomOfLine(startSerialIndex, bomCodeIndex, idIndex, line, bomCodeMap);
            startSerialIndex = index.get("startSerialIndex");
            bomCodeIndex = index.get("bomCodeIndex");
            idIndex = index.get("idIndex");
        }
    }

    private Map<String, Integer> getBomOfLine(int startSerialIndex, int bomCodeIndex, int idIndex, String line, Map<String, String> bomCodeMap) {
        HashMap<String, Integer> parm = new HashMap<String, Integer>();
        StringBuffer slotId = new StringBuffer();
        StringBuffer serialCode = new StringBuffer();
        StringBuffer bom = new StringBuffer();
        if (startSerialIndex != -1 && bomCodeIndex != -1) {
            if (line.contains("=")) {
                startSerialIndex = -1;
                bomCodeIndex = -1;
                parm.put("startSerialIndex", startSerialIndex);
                parm.put("bomCodeIndex", bomCodeIndex);
                parm.put("idIndex", idIndex);
                return parm;
            }
            this.addSeridAndBom(line, startSerialIndex, bomCodeIndex, serialCode, bom);
            this.setBom(serialCode.toString(), bom.toString(), bomCodeMap);
        }
        if (idIndex != -1 && bomCodeIndex != -1) {
            if (line.contains("=")) {
                idIndex = -1;
                bomCodeIndex = -1;
                parm.put("startSerialIndex", startSerialIndex);
                parm.put("bomCodeIndex", bomCodeIndex);
                parm.put("idIndex", idIndex);
                return parm;
            }
            this.addIdAndBom(line, idIndex, bomCodeIndex, slotId, bom);
            this.setBom(slotId.toString(), bom.toString(), bomCodeMap);
        }
        parm.put("startSerialIndex", startSerialIndex);
        parm.put("bomCodeIndex", bomCodeIndex);
        parm.put("idIndex", idIndex);
        return parm;
    }

    private boolean containIgnoreCase(String source, String containedString) {
        return source.toLowerCase(Locale.ENGLISH).contains(containedString.toLowerCase(Locale.ENGLISH));
    }
}

