/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.monitor.impl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.monitor.interfaces.IStopAnalyzing;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;

public abstract class AnalyzeAdapter
implements IStopAnalyzing {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AnalyzeAdapter.class);

    public void stopAction() {
        int[] selectRows;
        int[] nArray = selectRows = MainLogAnaDialog.getInstance().layout.getPackageTable().getSelectedRows();
        int n = selectRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectRow = nArray[n2];
            for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
                if (logRow.getSelectRow() != MainLogAnaDialog.getInstance().layout.getPackageTable().convertRowIndexToModel(selectRow)) continue;
                this.stopSingleLogAnalyzing(logRow);
            }
            ++n2;
        }
        MainLogAnaDialog.getInstance().refreshDetailList(true);
    }

    @Override
    public void outOfMemoryStop() {
        for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
            this.stopSingleLogAnalyzing(logRow);
        }
        MainLogAnaDialog.getInstance().refreshDetailList(true);
    }

    public void stopAutoAction() {
        for (LogRow logRow : LoganalyzerContext.getInstance().getCurLogRows()) {
            if (ResourceUtil.getString((String)"info.nanlyze.tabel.type.faild").equals(logRow.getRow().getValueAt(3).toString())) continue;
            this.stopSingleLogAnalyzing(logRow);
        }
        MainLogAnaDialog.getInstance().refreshDetailList(true);
    }

    private void stopSingleLogAnalyzing(LogRow logRow) {
        logRow.setStop(true);
        this.stopResultList(logRow);
    }

    private void stopResultList(LogRow logRow) {
        try {
            logRow.setNeedWait(true);
            boolean finish = ResourceUtil.getString((String)"info.nanlyze.tabel.type.done").equals(logRow.getRow().getValueAt(3));
            boolean isStoped = ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopped").equals(logRow.getRow().getValueAt(3));
            boolean notAnalyze = ResourceUtil.getString((String)"info.nanlyze.tabel.type.before").equals(logRow.getRow().getValueAt(3));
            if (!(finish || isStoped || notAnalyze)) {
                ImageIcon icon = ResourceUtil.getImage((String)"loading.gif");
                icon.setImageObserver((ImageObserver)((Object)MainLogAnaDialog.getInstance()));
                IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopping"));
                logRow.getRow().setValueAt(3, (Object)cell);
                logRow.setRow(logRow.getRow());
                logRow.setStauts("info.nanlyze.tabel.type.stopping");
                LOGGER.info("has stoped finish : " + finish);
            }
        }
        finally {
            logRow.notifyAnalysisThread();
            logRow.setNeedWait(false);
        }
    }
}

