/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.monitor.impl;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.execresult.ExecuteResult;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.ArchiveDirType;
import com.huawei.ism.tool.loganalyzer.monitor.interfaces.IAutoAnalyzeService;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaLayout;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class AutoAnalyzeService
implements IAutoAnalyzeService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AutoAnalyzeService.class);

    @Override
    public void createAutoAnalyzeDir() {
        ArchiveDirType[] archiveDirTypeArray = ArchiveDirType.values();
        int n = archiveDirTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveDirType dirType = archiveDirTypeArray[n2];
            File bakDir = new File(this.getMonitorDir(), dirType.getDirName());
            if (!bakDir.exists() && !bakDir.mkdir()) {
                LOGGER.error("create archive dir fail:" + bakDir.getAbsolutePath());
            }
            ++n2;
        }
    }

    @Override
    public File getMonitorDir() {
        String monitorDirPath = "d:\\silence";
        File monitorDir = new File(monitorDirPath);
        if (!monitorDir.exists() && !monitorDir.mkdirs()) {
            LOGGER.error("mkdirs file in the method AutoAnalyzeTask.init: " + monitorDir.getAbsolutePath());
        }
        return monitorDir;
    }

    @Override
    public void achiveLogFile(String logFileName, ArchiveDirType archiveDirType) {
        File oldFile;
        File monitorDir = this.getMonitorDir();
        File logPackageFile = new File(monitorDir, logFileName);
        File archiveDir = new File(monitorDir, archiveDirType.getDirName());
        if (!archiveDir.isDirectory() && !archiveDir.mkdirs()) {
            LOGGER.error("create archive dir fail:" + archiveDir.getAbsolutePath());
        }
        if ((oldFile = new File(archiveDir, logFileName)).exists() && !oldFile.delete()) {
            LOGGER.error("delete old archive log file fail:" + oldFile.getAbsolutePath());
        }
        if (!logPackageFile.renameTo(oldFile)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                LOGGER.error("archive exception:" + e);
            }
            LOGGER.error("First time archive failed");
            if (!logPackageFile.renameTo(oldFile)) {
                LOGGER.error("Second time archive failed");
            }
        }
    }

    @Override
    public void removeRepeatLogPackage(List<File> packages) {
        Set<LogRow> logRowsAll = LoganalyzerContext.getInstance().getCurLogRows();
        ArrayList<TableRow<Long, Object>> needDeleteTableRows = new ArrayList<TableRow<Long, Object>>();
        ArrayList<LogRow> needDeleteLogRows = new ArrayList<LogRow>();
        for (File file : packages) {
            for (LogRow logRow : logRowsAll) {
                if (!logRow.getLogFile().getName().equals(file.getName())) continue;
                needDeleteTableRows.add((TableRow<Long, Object>)logRow.getRow());
                needDeleteLogRows.add(logRow);
            }
        }
        this.removeLogPackage(needDeleteTableRows, needDeleteLogRows);
    }

    @Override
    public void removeRepeatLogPackage(LogRow logRow) {
        ArrayList<TableRow<Long, Object>> needDeleteTableRows = new ArrayList<TableRow<Long, Object>>();
        ArrayList<LogRow> needDeleteLogRows = new ArrayList<LogRow>();
        needDeleteTableRows.add(logRow.getRow());
        needDeleteLogRows.add(logRow);
        this.removeLogPackage(needDeleteTableRows, needDeleteLogRows);
    }

    @Override
    public void removeLogPackage(List<TableRow<Long, Object>> needDeleteTableRows, List<LogRow> needDeleteLogRows) {
        AsyncExcutor.submit((Callable)new DeleteRowLuceneFile(needDeleteLogRows));
        MainLogAnaLayout layout = MainLogAnaDialog.getInstance().layout;
        ArrayList<TableRow<Long, Object>> needDeleteTableRows1 = new ArrayList<TableRow<Long, Object>>();
        for (TableRow<Long, Object> tableRow : needDeleteTableRows) {
            needDeleteTableRows1.add(tableRow);
        }
        layout.getPackageProTableModel().removeRow(needDeleteTableRows1);
        List allRows = layout.getPackageProTableModel().getAllRows();
        layout.getPackageProTableModel().updateRow(allRows);
        this.deleteLog(needDeleteTableRows);
        MainLogAnaDialog.getInstance().refreshDetailList(true);
    }

    private void deleteLog(List<TableRow<Long, Object>> selectedLogRows) {
        for (TableRow<Long, Object> logRow : selectedLogRows) {
            this.deleteSelectedTmp(logRow.getValueAt(0).toString());
            MainLogAnaDialog.getInstance().refreshCurLogRow(logRow);
        }
    }

    private void deleteSelectedTmp(String selectedTempFile) {
        Map<String, File> logMappingName = LoganalyzerContext.getInstance().getLogTempMap();
        if (logMappingName.isEmpty()) {
            return;
        }
        for (Map.Entry<String, File> logMapEntry : logMappingName.entrySet()) {
            if (!selectedTempFile.equals(logMapEntry.getKey())) continue;
            FileAssistant.clearDir((String)logMapEntry.getValue().getAbsolutePath());
        }
    }

    @Override
    public void archiveImportFail(TaskResult result, String logFileName) {
        boolean flag = false;
        if ("Can not open file as archive".equals(result.getErrorLocaleDescription())) {
            flag = true;
        } else if ("file name contain specialcharacter".equals(result.getErrorLocaleDescription())) {
            flag = true;
        } else if ("The package is incorrectness".equals(result.getErrorLocaleDescription())) {
            flag = true;
        } else if ("too big".equals(result.getErrorLocaleDescription())) {
            flag = true;
        }
        List<ExecuteResult> resultMessgList = MainLogAnaDialog.getInstance().getResultMessgList();
        if (!resultMessgList.isEmpty()) {
            resultMessgList.remove(resultMessgList.size() - 1);
        }
        if (flag) {
            this.achiveLogFile(logFileName, ArchiveDirType.IMPORT_FAIL);
        }
    }

    private static final class DeleteRowLuceneFile
    implements Callable<Object> {
        private List<LogRow> needDeleteLogRows;

        public DeleteRowLuceneFile(List<LogRow> needDeleteLogRows) {
            this.needDeleteLogRows = needDeleteLogRows;
        }

        @Override
        public Object call() {
            for (LogRow logRow : this.needDeleteLogRows) {
                if (StringUtils.isNULLStr((String)logRow.getIndexDir())) continue;
                SearcherUtils.deleteTempFile(new File(logRow.getIndexDir()));
            }
            return true;
        }
    }
}

