/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexConfig;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexReaderManager;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.DocumentHandlerException;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.DocumentHandlerInitException;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.LuceneIndexPathError;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public final class DocumentHandler {
    private Directory dir;
    private IndexWriter writer;
    private IndexSearcher searcher;
    private DirectoryReader reader;
    private String indexName;
    private IndexConfig config;

    DocumentHandler(IndexConfig config) throws DocumentHandlerInitException {
        try {
            this.config = config;
            this.indexName = config.getTableName();
            File indexBaseDir = new File(config.getInstallDir(), this.indexName);
            if (!indexBaseDir.exists() && !indexBaseDir.mkdirs()) {
                throw new LuceneIndexPathError("Lucene Index base install path is wrong:" + indexBaseDir.getAbsolutePath());
            }
            this.dir = FSDirectory.open((Path)indexBaseDir.toPath());
            this.initIndexWriter(this.getWriterConfig());
        }
        catch (Exception e) {
            throw new DocumentHandlerInitException(String.valueOf(this.indexName) + " DocumentHandler(File dirFile) :", e);
        }
    }

    private IndexWriterConfig getWriterConfig() throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> c = Class.forName(this.config.getAnalyzer()).getConstructor(new Class[0]);
        c.setAccessible(true);
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)c.newInstance(new Object[0]));
        iwc.setOpenMode(this.config.getOpenMode());
        iwc.setRAMBufferSizeMB((double)this.config.getRamBufferSize());
        iwc.setReaderPooling(true);
        return iwc;
    }

    void add(Document doc) throws DocumentHandlerException {
        try {
            this.writer.addDocument((Iterable)doc);
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.add(Document doc):", e);
        }
    }

    void delete(Query ... q) throws DocumentHandlerException {
        try {
            this.writer.deleteDocuments(q);
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.delete(Query q):", e);
        }
    }

    public void commit() throws DocumentHandlerException {
        try {
            this.writer.commit();
            this.refreshReaderAndSearcher();
        }
        catch (Exception e) {
            this.rollback();
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.commit():", e);
        }
    }

    public void forceMergeDeletes() throws DocumentHandlerException {
        try {
            this.writer.forceMergeDeletes();
            this.commit();
            this.writer.deleteUnusedFiles();
            this.commit();
        }
        catch (Exception e) {
            this.rollback();
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.forceMergeDeletes():", e);
        }
    }

    public void forceMerge(int maxNumSegments) throws DocumentHandlerException {
        try {
            this.writer.forceMerge(maxNumSegments);
            this.commit();
        }
        catch (Exception e) {
            this.rollback();
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.forceMerge():", e);
        }
    }

    int numDeletedDocs() {
        return this.reader.numDeletedDocs();
    }

    long realSize() throws DocumentHandlerException {
        try {
            long dbSize = 0L;
            for (IndexCommit indexCommit : DirectoryReader.listCommits((Directory)this.dir)) {
                for (String fileName : indexCommit.getFileNames()) {
                    dbSize += this.fileLength(fileName);
                }
            }
            return dbSize += this.fileLength("segments.gen");
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " indexRealSize:", e);
        }
    }

    long totalSize() throws DocumentHandlerException {
        try {
            long dbSize = 0L;
            String[] stringArray = this.dir.listAll();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                dbSize += this.fileLength(fileName);
                ++n2;
            }
            return dbSize;
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " indexTotalSize:", e);
        }
    }

    void deleteAll() throws DocumentHandlerException {
        try {
            this.writer.deleteAll();
            this.commit();
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " destroy:", e);
        }
    }

    public String indexTableName() {
        return this.indexName;
    }

    public boolean hasUncommittedChanges() {
        return this.writer.hasUncommittedChanges();
    }

    public boolean hasDeletions() {
        return this.writer.hasDeletions();
    }

    public IndexSearcher getSearcher() {
        IndexSearcher seac = this.searcher;
        IndexReaderManager.incIndexReaderRefCount(seac.getIndexReader());
        return seac;
    }

    private long fileLength(String fileName) {
        try {
            return this.dir.fileLength(fileName);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void initIndexWriter(IndexWriterConfig iwc) throws DocumentHandlerException {
        try {
            this.writer = new IndexWriter(this.dir, iwc);
            if (!DirectoryReader.indexExists((Directory)this.dir)) {
                this.commit();
            } else {
                this.refreshReaderAndSearcher();
            }
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.initIndexWriter():", e);
        }
    }

    private void refreshReaderAndSearcher() throws DocumentHandlerException {
        try {
            if (this.reader == null) {
                DirectoryReader read = DirectoryReader.open((IndexWriter)this.writer);
                IndexReaderManager.bindIndexReaderRefCounter((IndexReader)read);
                this.reader = read;
                this.searcher = new IndexSearcher((IndexReader)this.reader);
            } else {
                DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)this.reader, (IndexWriter)this.writer, (boolean)true);
                if (newReader != null && newReader != this.reader) {
                    IndexReaderManager.bindIndexReaderRefCounter((IndexReader)newReader);
                    DirectoryReader oldReader = this.reader;
                    this.reader = newReader;
                    this.searcher = new IndexSearcher((IndexReader)this.reader);
                    IndexReaderManager.addOldReader((IndexReader)oldReader);
                }
            }
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.refreshReaderAndSearcher():", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback() throws DocumentHandlerException {
        try {
            Directory directory = this.dir;
            synchronized (directory) {
                while (this.writer != null) {
                    IndexWriter curWriter = this.writer;
                    this.writer = null;
                    this.dir.wait(500L);
                    curWriter.rollback();
                }
                this.initIndexWriter(this.getWriterConfig());
            }
        }
        catch (Exception e) {
            throw new DocumentHandlerException(String.valueOf(this.indexName) + " IndexDocHandler.rollback():", e);
        }
    }
}

