/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.huawei.ism.tool.loganalyzer.persist.dao.annotation.IndexEntity;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexConfig;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojo;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.IndexTableConfigParseException;
import com.huawei.ism.tool.loganalyzer.persist.dao.util.NamingUtil;
import org.apache.lucene.index.IndexWriterConfig;

public class IndexConfigParser {
    public static final <T extends IndexPojo> IndexConfig parse(Class<T> clazz) throws IndexTableConfigParseException {
        IndexConfig config = new IndexConfig();
        IndexEntity it = clazz.getAnnotation(IndexEntity.class);
        if (it == null) {
            config.setTableName(NamingUtil.toIndexTableName(clazz.getSimpleName()));
            config.setRamBufferSize(30);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            config.setAnalyzer("org.apache.lucene.analysis.core.WhitespaceAnalyzer");
            return config;
        }
        if (it.name().trim().equals("")) {
            config.setTableName(NamingUtil.toIndexTableName(clazz.getSimpleName()));
        }
        if (it.ramBufferSize() < 0) {
            throw new IndexTableConfigParseException("Note that the ramBufferSize can not be less than 0 !");
        }
        if (it.ramCheckFeq() < 0) {
            throw new IndexTableConfigParseException("Note that the ramCalFrequency can not be less than 0 !");
        }
        config.setAutoCommit(it.autoCommit());
        config.setRamBufferSize(it.ramBufferSize());
        config.setOpenMode(it.openMode());
        config.setAnalyzer(it.analyzer());
        return config;
    }
}

