/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.loganalyzer.persist.config.SystemConfig;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.DocumentHandler;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexConfig;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexConfigParser;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojo;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojoDaoImpl;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojoFieldParser;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexReaderManager;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.LuceneIndexLoadException;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.LuceneIndexPathError;
import com.huawei.ism.tool.loganalyzer.persist.dao.interfaces.IndexPojoDao;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public final class IndexPojoDaoFactory {
    private static final Logger LOG = Logger.getLogger(IndexPojoDaoFactory.class.getName());
    private static final Map<Class<? extends IndexPojo>, IndexPojoDao<? extends IndexPojo>> DAOMAP = new ConcurrentHashMap<Class<? extends IndexPojo>, IndexPojoDao<? extends IndexPojo>>();
    private static IndexPojoDaoFactory factory;
    private File installDir;

    private IndexPojoDaoFactory() {
        IndexReaderManager.init();
    }

    public static synchronized IndexPojoDaoFactory getInstance(String installDir) {
        if (factory == null) {
            File indexBaseRootDir = new File(installDir);
            if (!indexBaseRootDir.isDirectory() && !indexBaseRootDir.mkdirs()) {
                LOG.severe("Lucene Index base install path is wrong:" + installDir);
                throw new LuceneIndexPathError("Lucene Index base install path is wrong:" + installDir);
            }
            factory = new IndexPojoDaoFactory();
            IndexPojoDaoFactory.factory.installDir = indexBaseRootDir;
            LOG.info("Lucene Index root path:".concat(IndexPojoDaoFactory.factory.installDir.getAbsolutePath()));
        }
        return factory;
    }

    public <T extends IndexPojo> void load(Class<T> pojoClass) throws LuceneIndexLoadException {
        try {
            long lstart = System.currentTimeMillis();
            IndexConfig config = IndexConfigParser.parse(pojoClass);
            config.setInstallDir(this.installDir);
            IndexPojoDaoImpl dao = new IndexPojoDaoImpl(IndexPojoFieldParser.parse(pojoClass), ConstructorAccess.get(pojoClass), new DocumentHandler(config));
            DAOMAP.put(pojoClass, dao);
            LOG.info(String.valueOf("IndexPojoDAO<".concat(pojoClass.getSimpleName()).concat("> Initialized success in ").concat(String.valueOf(System.currentTimeMillis() - lstart)).concat("ms ! Max doc number:")) + dao.hitCount((Query)new MatchAllDocsQuery()));
        }
        catch (Exception e) {
            try {
                Collection<IndexPojoDao<? extends IndexPojo>> successDaoList = IndexPojoDaoFactory.getIndexPojoDaoCollection();
                for (IndexPojoDao<? extends IndexPojo> indexPojoDao : successDaoList) {
                    indexPojoDao.deleteAll();
                }
                FileUtils.deleteFile((File)new File(String.valueOf(SystemConfig.getInstance().getDBInstallPath()) + File.separator + "data"));
                FileUtils.deleteFile((File)new File(SearchConstant.getInstant().getTemp()));
                long lstart = System.currentTimeMillis();
                IndexConfig config = IndexConfigParser.parse(pojoClass);
                config.setInstallDir(this.installDir);
                IndexPojoDaoImpl dao = new IndexPojoDaoImpl(IndexPojoFieldParser.parse(pojoClass), ConstructorAccess.get(pojoClass), new DocumentHandler(config));
                DAOMAP.put(pojoClass, dao);
                LOG.info(String.valueOf("IndexPojoDAO<".concat(pojoClass.getSimpleName()).concat("> Initialized success in ").concat(String.valueOf(System.currentTimeMillis() - lstart)).concat("ms ! Max doc number:")) + dao.hitCount((Query)new MatchAllDocsQuery()));
            }
            catch (Exception e1) {
                LOG.severe(e1.getMessage());
                throw new LuceneIndexLoadException("IndexPojoDAO<".concat(pojoClass.getSimpleName()).concat("> Initialized failed !"), e1);
            }
        }
    }

    public static Collection<IndexPojoDao<? extends IndexPojo>> getIndexPojoDaoCollection() {
        return DAOMAP.values();
    }

    public static <T extends IndexPojo> IndexPojoDao<T> get(Class<T> pojoClass) {
        IndexPojoDao<? extends IndexPojo> indexPojoDao = DAOMAP.get(pojoClass);
        if (indexPojoDao == null) {
            throw new NullPointerException("Can't find the IndexPojoDao<" + pojoClass.getSimpleName() + "> instance in daoMap!");
        }
        return indexPojoDao;
    }
}

