/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.DocumentHandler;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojo;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexReaderManager;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.DocumentHandlerException;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.IndexPojoDaoException;
import com.huawei.ism.tool.loganalyzer.persist.dao.interfaces.IndexPojoDao;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.IndexPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.util.IndexPojoList;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;

public class IndexPojoDaoImpl<T extends IndexPojo>
implements IndexPojoDao<T> {
    private Map<String, IndexPojoField> pojoFieldMap;
    private ConstructorAccess<T> pojoConstructor;
    private DocumentHandler docHandler;

    public IndexPojoDaoImpl(Map<String, IndexPojoField> pojoFieldMap, ConstructorAccess<T> pojoConstructor, DocumentHandler docHandler) {
        this.pojoFieldMap = pojoFieldMap;
        this.pojoConstructor = pojoConstructor;
        this.docHandler = docHandler;
    }

    @Override
    public void save(T pojo) throws IndexPojoDaoException {
        try {
            Document doc = new Document();
            for (IndexPojoField ipf : this.pojoFieldMap.values()) {
                IndexableField f = ipf.toIndexableField(pojo);
                if (f == null) continue;
                doc.add(f);
            }
            this.docHandler.add(doc);
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.save:", e);
        }
    }

    @Override
    public void delete(Query query) throws IndexPojoDaoException {
        try {
            this.docHandler.delete(query);
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.delete(Query query):", e);
        }
    }

    @Override
    public void forceMergeDeletes() throws IndexPojoDaoException {
        try {
            this.docHandler.forceMergeDeletes();
        }
        catch (Exception e) {
            throw new IndexPojoDaoException("IndexPojoDao.forceMergeDeletes()", e);
        }
    }

    @Override
    public void forceMerge(int maxNumSegments) throws IndexPojoDaoException {
        try {
            this.docHandler.forceMerge(maxNumSegments);
        }
        catch (Exception e) {
            throw new IndexPojoDaoException("IndexPojoDao.forceMergeDeletes()", e);
        }
    }

    @Override
    public void commit() throws IndexPojoDaoException {
        try {
            this.docHandler.commit();
        }
        catch (Exception e) {
            throw new IndexPojoDaoException("IndexPojoDao.commit()", e);
        }
    }

    @Override
    public T get(Query query) throws IndexPojoDaoException {
        try {
            IndexSearcher searcher = this.docHandler.getSearcher();
            TopDocs docs = searcher.search(query, 1);
            IndexReaderManager.decIndexReaderRefCount(searcher.getIndexReader());
            return docs.totalHits > 0L ? (T)this.toIndexPojo(searcher.getIndexReader(), docs.scoreDocs[0].doc) : null;
        }
        catch (Exception e) {
            throw new IndexPojoDaoException("IndexPojoDao.query(Query query)", e);
        }
    }

    @Override
    public int hitCount(Query query) throws IndexPojoDaoException {
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            IndexSearcher searcher = this.docHandler.getSearcher();
            searcher.search(query, (Collector)collector);
            IndexReaderManager.decIndexReaderRefCount(searcher.getIndexReader());
            return collector.getTotalHits();
        }
        catch (Exception e) {
            throw new IndexPojoDaoException("IndexPojoDao.hitTotalCount(Query query)", e);
        }
    }

    @Override
    public IndexPojoList<T> query(Query query) throws IndexPojoDaoException {
        try {
            IndexSearcher searcher = this.docHandler.getSearcher();
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)(searcher.getIndexReader().numDocs() > 0 ? searcher.getIndexReader().numDocs() : 1));
            searcher.search(query, (Collector)collector);
            return new IndexPojoList(collector.getTotalHits(), collector.topDocs((int)0, (int)collector.getTotalHits()).scoreDocs, this, searcher.getIndexReader());
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.query(Query query):", e);
        }
    }

    @Override
    public IndexPojoList<T> query(Query query, int start, int howMany) throws IndexPojoDaoException {
        try {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)(start + howMany));
            IndexSearcher searcher = this.docHandler.getSearcher();
            searcher.search(query, (Collector)collector);
            return new IndexPojoList(collector.getTotalHits(), collector.topDocs((int)start, (int)howMany).scoreDocs, this, searcher.getIndexReader());
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.query(Query query, int start, int howMany):", e);
        }
    }

    @Override
    public IndexPojoList<T> query(Query query, Sort sort, int start, int howMany) throws IndexPojoDaoException {
        try {
            TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)(start + howMany), (boolean)false, (boolean)false, (boolean)false);
            IndexSearcher searcher = this.docHandler.getSearcher();
            searcher.search(query, (Collector)collector);
            return new IndexPojoList(collector.getTotalHits(), collector.topDocs((int)start, (int)howMany).scoreDocs, this, searcher.getIndexReader());
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.query(Query query, Sort sort, int start, int howMany):", e);
        }
    }

    @Override
    public T toIndexPojo(IndexReader indexReader, int docID) throws IndexPojoDaoException {
        Document doc;
        block4: {
            doc = indexReader.document(docID);
            if (doc != null) break block4;
            return null;
        }
        try {
            IndexPojo pojo = (IndexPojo)this.pojoConstructor.newInstance();
            for (IndexableField f : doc) {
                this.pojoFieldMap.get(f.name()).setValue(pojo, f);
            }
            return (T)pojo;
        }
        catch (Exception e) {
            throw new IndexPojoDaoException(String.valueOf(this.docHandler.indexTableName()) + " IndexPojoDao.toIndexPojo(IndexReader indexReader, int docID):", e);
        }
    }

    @Override
    public String indexTableName() {
        return this.docHandler.indexTableName();
    }

    @Override
    public int numDeletedDocs() {
        return this.docHandler.numDeletedDocs();
    }

    @Override
    public long realSize() throws IndexPojoDaoException {
        try {
            return this.docHandler.realSize();
        }
        catch (DocumentHandlerException e) {
            throw new IndexPojoDaoException("IndexPojoDao.indexRealSize()", e);
        }
    }

    @Override
    public long totalSize() throws IndexPojoDaoException {
        try {
            return this.docHandler.totalSize();
        }
        catch (DocumentHandlerException e) {
            throw new IndexPojoDaoException("IndexPojoDao.indexTotalSize()", e);
        }
    }

    @Override
    public void deleteAll() throws DocumentHandlerException {
        this.docHandler.deleteAll();
    }
}

