/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.huawei.ism.tool.loganalyzer.persist.dao.annotation.FieldDescription;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.FieldIndexType;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojo;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.IndexPojoFieldParseException;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.BinaryPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.BytePojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.DoublePojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.FloatPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.IndexPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.IntegerPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.LongPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.ShortPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.pojofield.StringPojoField;
import com.huawei.ism.tool.loganalyzer.persist.dao.util.NamingUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexOptions;

public class IndexPojoFieldParser {
    private static final Set<Class<?>> PARAMTYPESET = new HashSet(14);

    static {
        PARAMTYPESET.add(byte[].class);
        PARAMTYPESET.add(Byte.class);
        PARAMTYPESET.add(Byte.TYPE);
        PARAMTYPESET.add(Short.class);
        PARAMTYPESET.add(Short.TYPE);
        PARAMTYPESET.add(Integer.class);
        PARAMTYPESET.add(Integer.TYPE);
        PARAMTYPESET.add(Long.class);
        PARAMTYPESET.add(Long.TYPE);
        PARAMTYPESET.add(Float.class);
        PARAMTYPESET.add(Float.TYPE);
        PARAMTYPESET.add(Double.class);
        PARAMTYPESET.add(Double.TYPE);
        PARAMTYPESET.add(String.class);
    }

    public static final <T extends IndexPojo> Map<String, IndexPojoField> parse(Class<T> clazz) throws IndexPojoFieldParseException {
        MethodAccess access = MethodAccess.get(clazz);
        Map<String, Method> methodMap = IndexPojoFieldParser.getMethodMap(clazz);
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, IndexPojoField> indexPojoFieldMap = new HashMap<String, IndexPojoField>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                String fieldName = field.getName();
                char firstChar = fieldName.charAt(0);
                Class<?> fieldType = field.getType();
                IndexPojoFieldParser.checkoutField(clazz, fieldName, firstChar, fieldType);
                String str = String.valueOf(Character.toUpperCase(firstChar)) + fieldName.substring(1);
                Method getMethod = methodMap.get("get".concat(str));
                Method setMethod = methodMap.get("set".concat(str));
                if (getMethod == null) {
                    throw new IndexPojoFieldParseException("Can't find the get method named ".concat("get".concat(str)).concat(" for the field ").concat(fieldName));
                }
                if (setMethod == null) {
                    throw new IndexPojoFieldParseException("Can't find the set method named ".concat("set".concat(str)).concat(" for the field ").concat(fieldName));
                }
                IndexPojoField indexPojoField = IndexPojoFieldParser.toPojoField(field.getAnnotation(FieldDescription.class), fieldType);
                if (indexPojoField == null) {
                    throw new IndexPojoFieldParseException("Does't Support the Field Type:" + fieldType.getName());
                }
                indexPojoField.setAccess(access);
                indexPojoField.setName(NamingUtil.toIndexFieldName(fieldName));
                indexPojoField.setGetterIndex(access.getIndex(getMethod.getName()));
                indexPojoField.setSetterIndex(access.getIndex(setMethod.getName()));
                indexPojoFieldMap.put(indexPojoField.getName(), indexPojoField);
            }
            ++n2;
        }
        return indexPojoFieldMap;
    }

    private static final IndexPojoField toPojoField(FieldDescription fieldDescription, Class<?> fieldType) throws IndexPojoFieldParseException {
        IndexPojoField indexPojoField = null;
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            indexPojoField = new BytePojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseIntegerType(fieldDescription));
        } else if (fieldType == Short.TYPE || fieldType == Short.class) {
            indexPojoField = new ShortPojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseIntegerType(fieldDescription));
        } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            indexPojoField = new IntegerPojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseIntegerType(fieldDescription));
        } else if (fieldType == Long.TYPE || fieldType == Long.class) {
            indexPojoField = new LongPojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseLongType(fieldDescription));
        } else if (fieldType == Float.TYPE || fieldType == Float.class) {
            indexPojoField = new FloatPojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseFloatType(fieldDescription));
        } else if (fieldType == Double.TYPE || fieldType == Double.class) {
            indexPojoField = new DoublePojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseDoubleType(fieldDescription));
        } else if (fieldType == String.class) {
            indexPojoField = new StringPojoField();
            indexPojoField.setIndexType(IndexPojoFieldParser.parseStringType(fieldDescription));
        } else if (fieldType == byte[].class) {
            indexPojoField = new BinaryPojoField();
        }
        return indexPojoField;
    }

    private static FieldIndexType parseStringType(FieldDescription fieldDescription) {
        if (fieldDescription != null) {
            return new FieldIndexType(fieldDescription.indexed(), fieldDescription.tokenized(), fieldDescription.omitNorms(), fieldDescription.stored(), fieldDescription.option());
        }
        return new FieldIndexType(true, true, true, true, IndexOptions.DOCS);
    }

    private static FieldIndexType parseDoubleType(FieldDescription fieldDescription) {
        if (fieldDescription != null) {
            return new FieldIndexType(fieldDescription.indexed(), fieldDescription.tokenized(), fieldDescription.omitNorms(), fieldDescription.stored());
        }
        return new FieldIndexType(true, true, true, true);
    }

    private static FieldIndexType parseFloatType(FieldDescription fieldDescription) {
        if (fieldDescription != null) {
            return new FieldIndexType(fieldDescription.indexed(), fieldDescription.tokenized(), fieldDescription.omitNorms(), fieldDescription.stored());
        }
        return new FieldIndexType(true, true, true, true);
    }

    private static FieldIndexType parseLongType(FieldDescription fieldDescription) {
        if (fieldDescription != null) {
            return new FieldIndexType(fieldDescription.indexed(), fieldDescription.tokenized(), fieldDescription.omitNorms(), fieldDescription.stored());
        }
        return new FieldIndexType(true, true, true, true);
    }

    private static FieldIndexType parseIntegerType(FieldDescription fieldDescription) {
        if (fieldDescription != null) {
            return new FieldIndexType(fieldDescription.indexed(), fieldDescription.tokenized(), fieldDescription.omitNorms(), fieldDescription.stored());
        }
        return new FieldIndexType(true, true, true, true);
    }

    private static final <T extends IndexPojo> void checkoutField(Class<T> clazz, String fieldName, char firstChar, Class<?> fieldType) throws IndexPojoFieldParseException {
        if (Character.isUpperCase(firstChar)) {
            throw new IndexPojoFieldParseException("\u7d22\u5f15\u5e93\u521d\u59cb\u5316\u5931\u8d25\uff0c\u7c7b".concat(clazz.getName()).concat("\u4e2d\uff0c\u6210\u5458\u540d").concat(fieldName).concat("\u4e0d\u89c4\u8303\uff0c\u4e0d\u80fd\u4ee5\u5927\u5199\u5b57\u6bcd\u5f00\u5934!"));
        }
        if (!PARAMTYPESET.contains(fieldType)) {
            throw new IndexPojoFieldParseException("\u7d22\u5f15\u5e93\u521d\u59cb\u5316\u5931\u8d25\uff0c\u7c7b".concat(clazz.getName()).concat("\u4e2d\uff0c\u6210\u5458").concat(fieldName).concat("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u9650\u5b9a\u8303\u56f4").concat(PARAMTYPESET.toString()).concat("\u4e4b\u4e00!"));
        }
    }

    private static final <T extends IndexPojo> Map<String, Method> getMethodMap(Class<T> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                methodMap.put(method.getName(), method);
            }
            ++n2;
        }
        return methodMap;
    }
}

