/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.core;

import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexReaderRefCounter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexReader;
import org.slf4j.LoggerFactory;

public class IndexReaderManager {
    private static final ConcurrentHashMap<IndexReader, Long> OLDREADERLIFEMAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<IndexReader, IndexReaderRefCounter> INDEXREADERREFCOUNTERMAP = new ConcurrentHashMap();
    private static final Thread READERLIFEMANAGERTHREAD = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (OLDREADERLIFEMAP.isEmpty()) {
                            this.doubleCheck();
                            1.sleep(500L);
                        }
                        Iterator it = OLDREADERLIFEMAP.entrySet().iterator();
                        while (it.hasNext()) {
                            this.doClose(it.next());
                        }
                        1.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(IndexReaderManager.class).debug("READERLIFEMANAGERTHREAD is error", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doubleCheck() throws InterruptedException {
            Class<IndexReaderManager> clazz = IndexReaderManager.class;
            synchronized (IndexReaderManager.class) {
                if (OLDREADERLIFEMAP.isEmpty()) {
                    int i = 0;
                    while (i < 1) {
                        IndexReaderManager.class.wait();
                        ++i;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void doClose(Map.Entry<IndexReader, Long> entry) throws IOException {
            try {
                IndexReader oldReader = entry.getKey();
                IndexReaderRefCounter counter = (IndexReaderRefCounter)INDEXREADERREFCOUNTERMAP.get(oldReader);
                if (counter.getRefCount() <= 0) {
                    this.doClose(oldReader);
                } else if (System.currentTimeMillis() - entry.getValue() > 3600000L) {
                    this.doClose(oldReader);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(IndexReaderManager.class).debug("index reader refcounter map is error", (Throwable)e);
            }
        }

        private void doClose(IndexReader oldReader) throws IOException {
            INDEXREADERREFCOUNTERMAP.remove(oldReader);
            OLDREADERLIFEMAP.remove(oldReader);
            oldReader.close();
        }
    };
    private static final int OLD_READER_MAX_LIFE = 3600000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addOldReader(IndexReader oldReader) {
        OLDREADERLIFEMAP.put(oldReader, System.currentTimeMillis());
        Class<IndexReaderManager> clazz = IndexReaderManager.class;
        synchronized (IndexReaderManager.class) {
            if (OLDREADERLIFEMAP.isEmpty() || !OLDREADERLIFEMAP.isEmpty()) {
                IndexReaderManager.class.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static final void bindIndexReaderRefCounter(IndexReader indexReader) {
        INDEXREADERREFCOUNTERMAP.put(indexReader, new IndexReaderRefCounter());
    }

    public static final void incIndexReaderRefCount(IndexReader indexReader) {
        IndexReaderRefCounter c = INDEXREADERREFCOUNTERMAP.get(indexReader);
        if (c != null) {
            c.incRefCount();
        }
    }

    public static final void decIndexReaderRefCount(IndexReader indexReader) {
        IndexReaderRefCounter c = INDEXREADERREFCOUNTERMAP.get(indexReader);
        if (c != null) {
            c.decRefCount();
        }
    }

    public static final void init() {
        READERLIFEMANAGERTHREAD.setName("Reader-Life-Manager-Thread");
        READERLIFEMANAGERTHREAD.setDaemon(true);
        READERLIFEMANAGERTHREAD.start();
    }
}

