/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.util;

import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojo;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexReaderManager;
import com.huawei.ism.tool.loganalyzer.persist.dao.interfaces.IndexPojoApply;
import com.huawei.ism.tool.loganalyzer.persist.dao.interfaces.IndexPojoDao;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;

public class IndexPojoList<T extends IndexPojo> {
    private IndexPojoDao<T> indexPojoDao;
    private IndexReader indexReader;
    private boolean isReleaseReaderRef;
    private boolean isBreak;
    private int totalHits;
    private ScoreDoc[] scoreDocs;

    public IndexPojoList(int totalHits, ScoreDoc[] scoreDocs, IndexPojoDao<T> indexPojoDao, IndexReader indexReader) {
        this.totalHits = totalHits;
        this.scoreDocs = (ScoreDoc[])scoreDocs.clone();
        this.indexPojoDao = indexPojoDao;
        this.indexReader = indexReader;
    }

    public void foreach(IndexPojoApply<T> apply) throws Exception {
        if (this.scoreDocs != null) {
            try {
                ScoreDoc[] scoreDocArray = this.scoreDocs;
                int n = this.scoreDocs.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreDoc scoreDoc = scoreDocArray[n2];
                    apply.apply(this.indexPojoDao.toIndexPojo(this.indexReader, scoreDoc.doc));
                    ++n2;
                }
            }
            finally {
                this.decIndexReaderRefCount();
            }
        }
    }

    public void decIndexReaderRefCount() {
        if (!this.isReleaseReaderRef) {
            this.isReleaseReaderRef = true;
            IndexReaderManager.decIndexReaderRefCount(this.indexReader);
        }
    }

    public int size() {
        if (this.scoreDocs.length == 0) {
            this.decIndexReaderRefCount();
        }
        return this.scoreDocs.length;
    }

    public int getTotalHits() {
        if (this.scoreDocs.length == 0 || this.totalHits == 0) {
            this.decIndexReaderRefCount();
        }
        return this.totalHits;
    }

    public void setBreak(boolean isBre) {
        if (!this.isBreak) {
            this.isBreak = isBre;
        }
    }
}

