/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.util;

import com.esotericsoftware.kryo.Kryo;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.FaultObject;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogByteData;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogConfigInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.LoggerFactory;

public class KryoManager {
    private static final List<Class<?>> SERIALIZABLECLASSLIST;
    private static final ConcurrentHashMap<Thread, Kryo> KRYOTHREADMAP;
    private static final Queue<Kryo> KRYOQUEUE;
    private static byte maxKryoInstanceNum;
    private static byte curKryoInstanceNum;
    private static boolean isKryoSerializableClassInit;

    static {
        Class[] classArray;
        SERIALIZABLECLASSLIST = new ArrayList();
        KRYOTHREADMAP = new ConcurrentHashMap();
        KRYOQUEUE = new ConcurrentLinkedQueue<Kryo>();
        maxKryoInstanceNum = (byte)10;
        curKryoInstanceNum = 0;
        Class[] classArray2 = classArray = new Class[]{Set.class, Map.class, HashSet.class, HashMap.class, List.class, ArrayList.class, LogByteData.class, ResultCombination.class, RecordInfo.class, ResultCombination.Combination.class, Type.DateInfo.class, FaultObject.class, Rule.class, LogConfigInfo.class, CharSequence.class, File.class};
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class class1 = classArray2[n2];
            KryoManager.addSerializableClass(class1);
            ++n2;
        }
        KryoManager.initKryo();
    }

    public static final void setMaxKryoInstanceNum(byte maxKryoInstanceNum) {
        if (maxKryoInstanceNum > 0) {
            KryoManager.maxKryoInstanceNum = maxKryoInstanceNum;
        }
    }

    public static final void addSerializableClass(Class<?> clazz) {
        if (!SERIALIZABLECLASSLIST.contains(clazz) && !isKryoSerializableClassInit) {
            SERIALIZABLECLASSLIST.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void releaseKryoByThread() {
        Kryo k = KRYOTHREADMAP.remove(Thread.currentThread());
        if (k != null) {
            List<Class<?>> list = SERIALIZABLECLASSLIST;
            synchronized (list) {
                KRYOQUEUE.add(k);
                if (KRYOQUEUE.isEmpty() || !KRYOQUEUE.isEmpty()) {
                    SERIALIZABLECLASSLIST.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Kryo getKryo() {
        List<Class<?>> list = SERIALIZABLECLASSLIST;
        synchronized (list) {
            Kryo k;
            if (KRYOQUEUE.isEmpty() && KryoManager.isKryoInstanceNumFull()) {
                try {
                    int i = 0;
                    while (i < 1) {
                        SERIALIZABLECLASSLIST.wait();
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    LoggerFactory.getLogger(KryoManager.class).debug("serializable class list error", (Throwable)e);
                }
            }
            k = (k = KRYOQUEUE.poll()) == null ? KryoManager.getKryoInstance() : k;
            KRYOTHREADMAP.put(Thread.currentThread(), k);
            return k;
        }
    }

    private static final boolean isKryoInstanceNumFull() {
        return curKryoInstanceNum >= maxKryoInstanceNum;
    }

    private static final void sortKryoSerializableClass() {
        Collections.sort(SERIALIZABLECLASSLIST, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        isKryoSerializableClassInit = true;
    }

    private static Kryo getKryoInstance() {
        Kryo k = new Kryo();
        k.setRegistrationRequired(false);
        k.setReferences(true);
        int j = 0;
        while (j < SERIALIZABLECLASSLIST.size()) {
            k.register(SERIALIZABLECLASSLIST.get(j));
            ++j;
        }
        curKryoInstanceNum = (byte)(curKryoInstanceNum + 1);
        return k;
    }

    public static final void initKryo() {
        KryoManager.sortKryoSerializableClass();
    }
}

