/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.dao.util;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.SerializableException;
import com.huawei.ism.tool.loganalyzer.persist.dao.util.KryoManager;
import com.huawei.ism.tool.loganalyzer.persist.data.DiagnoseInfos;
import com.huawei.ism.tool.loganalyzer.persist.data.EventInfos;
import com.huawei.ism.tool.loganalyzer.persist.data.SysLogEventInfos;
import com.huawei.ism.tool.loganalyzer.worktaker.impl.LogWorkTakerImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class SystemSerializer {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogWorkTakerImpl.class);

    public static final byte[] write(List<?> list) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
            Output output = new Output((OutputStream)baos);
            KryoManager.getKryo().writeObject(output, list);
            output.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u5f02\u5e38write(List<?> pointList)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            KryoManager.releaseKryoByThread();
        }
    }

    public static final List<?> readList(byte[] bs) {
        Input input = null;
        try {
            input = new Input(bs);
            List list = (List)KryoManager.getKryo().readObject(input, ArrayList.class);
            return list;
        }
        catch (Exception e) {
            LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38OriginalFileContent readOriginalFileContent(byte[] bs)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            if (input != null) {
                input.close();
            }
            KryoManager.releaseKryoByThread();
        }
    }

    public static final byte[] write(Set<?> set) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
            Output output = new Output((OutputStream)baos);
            KryoManager.getKryo().writeObject(output, set);
            output.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u5f02\u5e38write(Set<?> set)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            KryoManager.releaseKryoByThread();
        }
    }

    public static final Set<?> readSet(byte[] bs) {
        Input input = null;
        try {
            input = new Input(bs);
            Set set = (Set)KryoManager.getKryo().readObject(input, HashSet.class);
            return set;
        }
        catch (Exception e) {
            LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38OriginalFileContent readOriginalFileContent(byte[] bs)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            if (input != null) {
                input.close();
            }
            KryoManager.releaseKryoByThread();
        }
    }

    public static final byte[] write(EventInfos content) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x600000);
            Output output = new Output((OutputStream)baos);
            KryoManager.getKryo().writeObject(output, (Object)content);
            output.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u5f02\u5e38write(OriginalFileContent content)\uff1a", (Throwable)e);
            throw new SerializableException(e);
        }
        finally {
            KryoManager.releaseKryoByThread();
        }
    }

    public static final EventInfos readEventInfos(byte[] bs) {
        Input input = null;
        try {
            input = new Input(bs);
            EventInfos eventInfos = (EventInfos)KryoManager.getKryo().readObject(input, EventInfos.class);
            return eventInfos;
        }
        catch (Exception e) {
            LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38OriginalFileContent readOriginalFileContent(byte[] bs)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            if (input != null) {
                input.close();
            }
            KryoManager.releaseKryoByThread();
        }
    }

    public static final byte[] write(DiagnoseInfos content) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x600000);
            Output output = new Output((OutputStream)baos);
            KryoManager.getKryo().writeObject(output, (Object)content);
            output.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u5f02\u5e38write(OriginalFileContent content)\uff1a", (Throwable)e);
            throw new SerializableException(e);
        }
        finally {
            KryoManager.releaseKryoByThread();
        }
    }

    public static final DiagnoseInfos readDiagnoseInfos(byte[] bs) {
        Input input = null;
        try {
            input = new Input(bs);
            DiagnoseInfos diagnoseInfos = (DiagnoseInfos)KryoManager.getKryo().readObject(input, DiagnoseInfos.class);
            return diagnoseInfos;
        }
        catch (Exception e) {
            LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38OriginalFileContent readOriginalFileContent(byte[] bs)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            if (input != null) {
                input.close();
            }
            KryoManager.releaseKryoByThread();
        }
    }

    public static final byte[] write(SysLogEventInfos content) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x600000);
            Output output = new Output((OutputStream)baos);
            KryoManager.getKryo().writeObject(output, (Object)content);
            output.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u5f02\u5e38write(OriginalFileContent content)\uff1a", (Throwable)e);
            throw new SerializableException(e);
        }
        finally {
            KryoManager.releaseKryoByThread();
        }
    }

    public static final SysLogEventInfos readSysLogEventInfos(byte[] bs) {
        Input input = null;
        try {
            input = new Input(bs);
            SysLogEventInfos sysLogEventInfos = (SysLogEventInfos)KryoManager.getKryo().readObject(input, SysLogEventInfos.class);
            return sysLogEventInfos;
        }
        catch (Exception e) {
            LOGGER.debug("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38OriginalFileContent readOriginalFileContent(byte[] bs)\uff1a", (Throwable)e);
            return null;
        }
        finally {
            if (input != null) {
                input.close();
            }
            KryoManager.releaseKryoByThread();
        }
    }
}

