/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.persist.util;

import com.huawei.ism.tool.loganalyzer.persist.config.SystemConfig;
import com.huawei.ism.tool.loganalyzer.persist.dao.core.IndexPojoDaoFactory;
import com.huawei.ism.tool.loganalyzer.persist.dao.exception.LuceneIndexLoadException;
import com.huawei.ism.tool.loganalyzer.persist.dao.interfaces.IndexPojoDao;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogByteData;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogConfigInfo;
import com.huawei.ism.tool.loganalyzer.persist.entity.LogInfo;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaoFactory.class);
    private static IndexPojoDaoFactory indexPojoDaoFactory;
    private static IndexPojoDao<LogInfo> logInfoPojoDao;
    private static IndexPojoDao<LogByteData> logByteDataPojoDao;
    private static IndexPojoDao<LogConfigInfo> logConfigInfoPojoDao;

    public static void initialize() {
        try {
            indexPojoDaoFactory = IndexPojoDaoFactory.getInstance(String.valueOf(SystemConfig.getInstance().getDBInstallPath()) + File.separator + "data54");
            indexPojoDaoFactory.load(LogInfo.class);
            indexPojoDaoFactory.load(LogByteData.class);
            indexPojoDaoFactory.load(LogConfigInfo.class);
            logInfoPojoDao = IndexPojoDaoFactory.get(LogInfo.class);
            logByteDataPojoDao = IndexPojoDaoFactory.get(LogByteData.class);
            logConfigInfoPojoDao = IndexPojoDaoFactory.get(LogConfigInfo.class);
            LOGGER.debug("lucene database init success! ");
        }
        catch (LuceneIndexLoadException e) {
            LOGGER.debug("lucene database init fail! ");
        }
    }

    public static void initializeSlience() {
        try {
            indexPojoDaoFactory = IndexPojoDaoFactory.getInstance("d:\\silence" + File.separator + "data");
            indexPojoDaoFactory.load(LogInfo.class);
            indexPojoDaoFactory.load(LogByteData.class);
            indexPojoDaoFactory.load(LogConfigInfo.class);
            logInfoPojoDao = IndexPojoDaoFactory.get(LogInfo.class);
            logByteDataPojoDao = IndexPojoDaoFactory.get(LogByteData.class);
            logConfigInfoPojoDao = IndexPojoDaoFactory.get(LogConfigInfo.class);
            LOGGER.debug("lucene database init success! ");
        }
        catch (LuceneIndexLoadException e) {
            LOGGER.debug("lucene database init fail! ");
        }
    }

    public void destroy() {
    }
}

