/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingFailedException;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.silence.AnaLogByPyCallerSilence;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeLogExecuterSilence {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeLogExecuterSilence.class);
    private static final int INT_NUM_10 = 10;
    private ExecutorService fixedNumExecutor = null;

    public AnalyzeLogExecuterSilence() {
        int num = 10;
        this.fixedNumExecutor = Executors.newFixedThreadPool(num);
    }

    private int doCompleteResult(List<Future<?>> futureList) {
        int searchCount = 0;
        Object isSuccess = null;
        for (Future<?> future : futureList) {
            try {
                isSuccess = future.get();
                if (isSuccess == null || !Boolean.parseBoolean(isSuccess.toString())) continue;
                ++searchCount;
            }
            catch (AnalyzingStopedException e) {
                throw e;
            }
            catch (AnalyzingFailedException e) {
                throw e;
            }
            catch (ExecutionException e) {
                this.doMyException(e);
            }
            catch (Exception e) {
                LOGGER.error("Do search index error.", (Throwable)e);
            }
        }
        return searchCount;
    }

    private void doMyException(ExecutionException e) {
        Throwable throwable = e.getCause();
        while (this.isMyExceptin(throwable)) {
            if (throwable instanceof AnalyzingFailedException) {
                throw (AnalyzingFailedException)throwable;
            }
            if (throwable instanceof AnalyzingStopedException) {
                throw (AnalyzingStopedException)throwable;
            }
            throwable = throwable.getCause();
        }
    }

    private boolean isMyExceptin(Throwable throwable) {
        return throwable instanceof AnalyzingFailedException || throwable instanceof AnalyzingStopedException;
    }

    public int executePythonCall(List<AnaLogByPyCallerSilence> logCallers) {
        ArrayList futureList = new ArrayList();
        for (AnaLogByPyCallerSilence call : logCallers) {
            try {
                Future<Object> f = this.fixedNumExecutor.submit(call);
                futureList.add(f);
            }
            catch (AnalyzingStopedException e) {
                throw e;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("invokeAll InterruptedException error.", (Throwable)e);
            }
        }
        return this.doCompleteResult(futureList);
    }
}

