/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.log.LogDeCompressDir;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.DecompressMain;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.ProcessExitException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DiskIsEnoughThread;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearchConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.IDeCompressPkgWorktaker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeCompressPkgWorktakerImplSilence
extends AbstractWorktaker
implements IDeCompressPkgWorktaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeCompressPkgWorktakerImplSilence.class);

    @Override
    public LogDeCompressDir convertLogDir(LogRow row, LogDeCompressDir logDeCompressDir, DiskIsEnoughThread isEnough) {
        File srcFile = row.getLogFile();
        HashMap<String, File> nameFileMap = new HashMap<String, File>();
        if (srcFile.isDirectory()) {
            logDeCompressDir.setDeDeCompressDir(srcFile);
            return logDeCompressDir;
        }
        File srcTempDir = new File(SearchConstant.getInstant().getTemp(), "InfoAnalyzer_LogSrcDir");
        String dirName = String.valueOf(System.nanoTime());
        String fileName = srcFile.getName();
        StringBuffer strb = new StringBuffer(dirName);
        strb.append("_");
        strb.append(fileName.subSequence(0, fileName.lastIndexOf(46)));
        dirName = strb.toString().trim();
        File logDir = new File(srcTempDir, dirName);
        logDeCompressDir.setDeDeCompressRandomDir(logDir);
        Map<String, File> logTempDir = LoganalyzerContext.getInstance().getLogTempMap();
        logTempDir.put(srcFile.getName(), logDir);
        Set<String> tempDir = LoganalyzerContext.getInstance().getTempFiles();
        tempDir.add(SearchConstant.getInstant().getTemp());
        nameFileMap.put(fileName, logDir);
        try {
            DecompressMain.decompress(srcFile, logDir, isEnough);
        }
        catch (ProcessExitException e) {
            SearcherUtils.deleteTempFile(logDir);
            throw e;
        }
        logDeCompressDir.setDeDeCompressDir(DecompressMain.getSystemLogPath(logDir));
        return logDeCompressDir;
    }
}

