/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.silence;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.LogRow;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingFailedException;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Version;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.model.SearchProgress;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.ProductInfo;
import com.huawei.ism.tool.loganalyzer.logic.AnalyzeUserOpService;
import com.huawei.ism.tool.loganalyzer.monitor.enumer.AnalysisMode;
import com.huawei.ism.tool.loganalyzer.silence.MainLogAnaDialogSilence;
import com.huawei.ism.tool.loganalyzer.silence.result.Rule;
import com.huawei.ism.tool.loganalyzer.ui.main.MainLogAnaDialog;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class DoLogAnalyzeSilence {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DoLogAnalyzeSilence.class);
    private List<LogRow> rows;

    public DoLogAnalyzeSilence(List<LogRow> rows) {
        this.rows = rows;
    }

    public List<Rule> logAnalyze(String model, String version) {
        return this.execLogAnalyze(model, version);
    }

    private List<Rule> execLogAnalyze(String model, String version) {
        boolean flag = false;
        ArrayList<Rule> resultList = new ArrayList<Rule>();
        for (LogRow row : this.rows) {
            try {
                if ((double)SearcherUtils.remainderMemory() < 80.0 && !flag) {
                    flag = true;
                    AnalysisMode.current().getStopAnalyzingInterface().outOfMemoryStop();
                }
                if (this.findWriteStatus(row).booleanValue()) {
                    this.refreshComponent(row);
                    this.revert(row);
                    continue;
                }
                row.setSearchProgress(new SearchProgress());
                row.getSearchProgress().setInfo(ResourceUtil.getString((String)"info.analyze.faultTree.progress.createsort"));
                this.setModel(row, model, version);
                LOGGER.info("Silence analyse model,version:" + model + version);
                this.doLogAnalyzing(row);
                row.setStauts("info.nanlyze.tabel.type.done");
                row.analyzeInterruptedFromStopCommand();
                List<ReportLog> result = row.getFaultTreeCauseLogs();
                if (!result.isEmpty()) {
                    for (ReportLog log : result) {
                        Rule rule = new Rule();
                        rule.setName(log.getName());
                        rule.setErrMsg(log.getDetail().getCause());
                        rule.setSuggestion(log.getDetail().getAction());
                        rule.setOccurTime(log.getOccurTime());
                        rule.setShowInfo(log.getRecordInfos());
                        resultList.add(rule);
                    }
                }
                SearcherUtils.deleteTempFile(new File(row.getLogDeCompressDir().getDeDeCompressRandomDir().getAbsolutePath()));
            }
            catch (AnalyzingStopedException e) {
                row.waitStopThreadFinish();
                AnalyzeUserOpService.stopAnalyzeRecord(row);
                this.handleStopCase(row);
                this.refreshStatus(row);
                LOGGER.info("The analyze log is stopped success : " + e.getMessage(), (Throwable)e);
            }
            catch (AnalyzingFailedException e) {
                this.doAnalyzedFailed(row, e);
            }
            catch (Exception e) {
                AnalyzeUserOpService.failedAnalyzeRecord(row);
            }
        }
        return resultList;
    }

    private void setModel(LogRow row, String model, String version) {
        ProductInfo pro = row.getProductInfo();
        pro.setMod(model);
        pro.setVer(version);
        row.setProductInfo(pro);
    }

    private void refreshStatus(LogRow row) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.stopped"));
        row.setStauts("info.nanlyze.tabel.type.stopped");
    }

    private void doOtherAnalyzedFailed(LogRow row, Throwable e) {
        LOGGER.error("Analyzing the log package occors an error ", e);
        if (!AnalysisMode.isAutoAnalysisMode()) {
            DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)"info.nanlyze.doing.error"));
            SearcherUtils.doRefreshDefaultArea(MainLogAnaDialog.getInstance());
        }
        this.deleteIndexDir(row);
    }

    private void doAnalyzedFailed(LogRow row, AnalyzingFailedException e) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.faild"));
        row.setStauts("info.nanlyze.tabel.type.faild");
        LOGGER.error("analyze log " + row.getLogFile() + "failed.", (Throwable)e);
        if (!AnalysisMode.isAutoAnalysisMode()) {
            DialogUtils.showInfoDialog((Frame)((Object)MainLogAnaDialog.getInstance()), (String)ResourceUtil.getString((String)e.getErrorSourceID()));
            SearcherUtils.doRefreshDefaultArea(MainLogAnaDialog.getInstance());
        }
        this.deleteIndexDir(row);
        AnalyzeUserOpService.failedAnalyzeRecord(row);
    }

    private void deleteIndexDir(LogRow row) {
        if (!StringUtils.isNULLStr((String)row.getIndexDir())) {
            SearcherUtils.deleteTempFile(new File(row.getIndexDir()));
        }
    }

    private void doLogAnalyzing(LogRow row) throws ToolException, IOException {
        row.setAnalyzeStartTime(System.currentTimeMillis());
        row.analyzeInterruptedFromStopCommand();
        new LogAnalyzeQueryCallable(row).call();
        row.analyzeInterruptedFromStopCommand();
    }

    private void deleteAndUpdateReportTmpDir(LogRow row) {
        if (!StringUtils.isNULLStr((String)row.getReportTmpFile())) {
            FileUtils.deleteFile((File)new File(row.getReportTmpFile()));
        }
        if (!new File(row.getReportTmpFile()).mkdirs()) {
            LOGGER.error("create dir fail:" + row.getReportTmpFile());
        }
    }

    private Boolean findWriteStatus(LogRow row) {
        Boolean flag = (Boolean)LoganalyzerContext.getInstance().getWriteVersionMap().get(row.getLogFile().getAbsolutePath());
        if (flag != null && flag.booleanValue() && StringUtils.isNULLStr((String)row.getVersion())) {
            return true;
        }
        return false;
    }

    private void refreshComponent(LogRow row) {
        row.getRow().setValueAt(3, (Object)ResourceUtil.getString((String)"info.nanlyze.tabel.type.before"));
        row.setStauts("info.nanlyze.tabel.type.before");
        if (!AnalysisMode.isAutoAnalysisMode()) {
            MainLogAnaDialog.getInstance().layout.getStopButton().setEnabled(false);
        }
        MainLogAnaDialog.getInstance().setAction(false);
        MainLogAnaDialog.getInstance().setFinish(true);
    }

    private void handleStopCase(LogRow row) {
        FileAssistant.clearDir((String)row.getIndexDir());
        this.revert(row);
    }

    private void revert(LogRow row) {
        TableRow tableRow = row.getRow();
        String writeVersion = row.getVersion();
        if (row.isTypeGetByCell()) {
            List<String> items = MainLogAnaDialog.getInstance().layout.getComboBoxItems();
            IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(items.toArray(), (Object)items.get(items.indexOf(row.getType())));
            tableRow.setValueAt(1, (Object)cell);
            ArrayList versions = new ArrayList();
            ArrayList<String> vList = new ArrayList<String>();
            List<Version> versionList = DeviceType.getModel(row.getType()).getVersionList();
            for (Version version : versionList) {
                vList.add(version.getValue());
            }
            versions.addAll(vList);
            IsmTableCell.ComboBoxCell verCell = new IsmTableCell.ComboBoxCell(versions.toArray(), versions.get(versions.indexOf(versions.get(0))));
            verCell.getComboBox().setEditable(true);
            IsmTableCell.ComboBoxCell writeVersionCell = new IsmTableCell.ComboBoxCell(versions.toArray(), (Object)writeVersion);
            writeVersionCell.getComboBox().setEditable(true);
            SearcherUtils.linkage(cell.getComboBox(), verCell, (TableRow<Integer, Long>)tableRow, 0);
            tableRow.setValueAt(2, (Object)writeVersionCell);
        }
    }

    public static final class LogAnalyzeQueryCallable
    implements Callable<Object> {
        private LogRow row;

        public LogAnalyzeQueryCallable(LogRow row) {
            this.row = row;
        }

        @Override
        public Object call() throws ToolException, IOException {
            TableRow tableRow = this.row.getRow();
            this.initEvn();
            MainLogAnaDialogSilence.getInstance().doAnalyzeOperation(this.row);
            this.row.getSearchProgress().setEndTime(System.currentTimeMillis());
            return true;
        }

        private void initEvn() {
            MainLogAnaDialogSilence.getInstance().deleteTmp(this.row);
        }

        public LogRow getRow() {
            return this.row;
        }

        public void setRow(LogRow row) {
            this.row = row;
        }
    }
}

